package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.ReportCatalogDisplay;
import io.intino.konos.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.ReportCatalogDisplayNotifier;

import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.spark.ActivitySparkManager;
import io.intino.konos.server.activity.spark.resources.DisplayRequester;

public class ReportCatalogDisplayRequester extends DisplayRequester {

	public ReportCatalogDisplayRequester(ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws KonosException {
		ReportCatalogDisplay display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("selectGrouping")) display.selectGrouping(manager.fromQuery("value", GroupingSelection.class));
		else if (operation.equals("clearFilter")) display.clearFilter();
		else if (operation.equals("timezoneOffset")) display.timezoneOffset(manager.fromQuery("value", Integer.class));
		else if (operation.equals("navigate")) display.navigate(manager.fromQuery("value", String.class));
	}
}