package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.OlapDisplay;
import io.intino.konos.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.OlapDisplayNotifier;

import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.spark.ActivitySparkManager;
import io.intino.konos.server.activity.spark.resources.DisplayRequester;

public class OlapDisplayRequester extends DisplayRequester {

	public OlapDisplayRequester(ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws KonosException {
		OlapDisplay display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("addTicket")) display.addTicket(manager.fromQuery("value", String.class));
		else if (operation.equals("removeTicket")) display.removeTicket(manager.fromQuery("value", String.class));
		else if (operation.equals("moveTickets")) display.moveTickets(manager.fromQuery("value", String[].class));
		else if (operation.equals("updateScale")) display.updateScale(manager.fromQuery("value", String.class));
		else if (operation.equals("updateRange")) display.updateRange(manager.fromQuery("value", RequestRange.class));
		else if (operation.equals("export")) {
			io.intino.konos.server.activity.spark.ActivityFile file = display.export(manager.fromQuery("value", RequestRange.class));
			manager.write(file.content(), file.label());
		}
		else if (operation.equals("removeDrillCategory")) display.removeDrillCategory(manager.fromQuery("value", String.class));
		else if (operation.equals("selectChart")) display.selectChart(manager.fromQuery("value", ChartOption.class));
		else if (operation.equals("removeFilter")) display.removeFilter(manager.fromQuery("value", String.class));
	}
}