package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.CategorizationComparatorDisplay;
import io.intino.konos.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.CategorizationComparatorDisplayNotifier;

import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.spark.ActivitySparkManager;
import io.intino.konos.server.activity.spark.resources.DisplayRequester;

public class CategorizationComparatorDisplayRequester extends DisplayRequester {

	public CategorizationComparatorDisplayRequester(ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws KonosException {
		CategorizationComparatorDisplay display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("includeGlobalSerie")) display.includeGlobalSerie(manager.fromQuery("value", Boolean.class));
		else if (operation.equals("apply")) display.apply();
		else if (operation.equals("quit")) display.quit();
	}
}