package io.intino.sumus.box.displays.providers;

import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.displays.ElementDisplay;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.box.schemas.SaveItemParameters;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.helpers.NameSpaceHandler;

import java.util.List;

public interface RecordDisplayProvider {
	Mold mold();
	Record record(String id);
	NameSpaceHandler nameSpaceHandler();
	NameSpace nameSpace();
	TimeRange range();

	List<Mold.Block> blocks(Mold mold);
	List<Mold.Block.Stamp> stamps(Mold mold);
	Mold.Block.Stamp stamp(Mold mold, String stampName);

	StampDisplay display(String name);
	ElementDisplay openElement(String label);

	void executeOperation(ElementOperationParameters params, List<Record> records);
	Resource downloadOperation(ElementOperationParameters params, List<Record> records);
	void saveItem(SaveItemParameters params, Record record);
}

