package io.intino.sumus.box.displays.builders;

import io.intino.sumus.box.schemas.*;
import io.intino.sumus.box.schemas.Operation;
import io.intino.sumus.graph.AbstractView;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static io.intino.sumus.graph.Catalog.*;
import static io.intino.sumus.graph.Toolbar.*;
import static java.util.Collections.singletonList;
import static java.util.stream.Collectors.toList;

public class ElementViewBuilder {

    public static ElementView build(io.intino.sumus.analytics.viewmodels.ElementView view) {
        ElementView result = new ElementView().name(view.name()).label(view.label());

        if (view.toolbar() != null)
            result.toolbar(buildToolbar(view.toolbar()));

        result.embeddedElement(view.embeddedElement());
        result.mold(MoldBuilder.build(view.mold()));
        result.type(view.type());
        result.width(view.width());
        result.canSearch(view.canSearch());
        result.canCreateClusters(view.canCreateClusters());
        result.clusters(view.clusters());
        result.emptyMessage(view.emptyMessage());
        addMapViewProperties(result, view);
        return result;
    }

    private static Toolbar buildToolbar(io.intino.sumus.graph.Toolbar toolbar) {
        Toolbar result = new Toolbar();
        toolbar.operationList().forEach(op -> result.operationList().add(buildOperation(op)));
        return result;
    }

    private static Operation buildOperation(io.intino.sumus.graph.Toolbar.Operation operation) {
        Operation result = new Operation().title(operation.title()).name(operation.name$());

        result.type(type(operation));
        result.icon(operation.sumusIcon());
        result.when(when(operation));
        result.propertyList(propertiesOf(operation));

        return result;
    }

    private static String when(io.intino.sumus.graph.Toolbar.Operation operation) {
        if (operation.i$(TaskSelection.class) || operation.i$(ExportSelection.class) ||
            operation.i$(DownloadSelection.class) || operation.i$(io.intino.sumus.graph.Toolbar.GroupingSelection.class))
            return "Selection";
        return "Always";
    }

    private static List<Property> propertiesOf(io.intino.sumus.graph.Toolbar.Operation operation) {

        if (operation.i$(Download.class))
            return singletonList(propertyOf("options", String.join(",", operation.a$(Download.class).options())));

        if (operation.i$(DownloadSelection.class))
            return singletonList(propertyOf("options", String.join(",", operation.a$(DownloadSelection.class).options())));

        if (operation.i$(Export.class)) {
            return new ArrayList<Property>() {{
                add(propertyOf("from", String.valueOf(operation.a$(Export.class).from().toEpochMilli())));
                add(propertyOf("to", String.valueOf(operation.a$(Export.class).to().toEpochMilli())));
            }};
        }

        if (operation.i$(ExportSelection.class)) {
            return new ArrayList<Property>() {{
                add(propertyOf("from", String.valueOf(operation.a$(ExportSelection.class).from().toEpochMilli())));
                add(propertyOf("to", String.valueOf(operation.a$(ExportSelection.class).to().toEpochMilli())));
            }};
        }

        return Collections.emptyList();
    }

    private static Property propertyOf(String name, String value) {
        return new Property().name(name).value(value);
    }

    private static String type(io.intino.sumus.graph.Toolbar.Operation operation) {
        if (operation.i$(Download.class) || operation.i$(DownloadSelection.class)) return "download";
        if (operation.i$(Export.class) || operation.i$(ExportSelection.class)) return "export";
        if (operation.i$(OpenDialog.class)) return "open-dialog";
        if (operation.i$(io.intino.sumus.graph.Toolbar.GroupingSelection.class)) return "grouping";
        return "operation";
    }

    public static List<ElementView> buildList(List<io.intino.sumus.analytics.viewmodels.ElementView> viewList) {
        return viewList.stream().map(ElementViewBuilder::build).collect(toList());
    }

    private static void addMapViewProperties(ElementView result, io.intino.sumus.analytics.viewmodels.ElementView view) {
        AbstractView rawView = view.raw();
        if (!rawView.i$(MapView.class)) return;

        MapView mapView = rawView.a$(MapView.class);
        MapView.Zoom zoom = mapView.zoom();
        MapView.Center center = mapView.center();

        result.center(new Center().latitude(center.latitude()).longitude(center.longitude()));
        result.zoom(new Zoom().min(zoom.min()).max(zoom.max()).defaultValue(zoom.default$()));
    }

}
