package io.intino.sumus.box.displays.adapters;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import io.intino.sumus.box.schemas.PlatformInfo;

import java.io.IOException;
import java.net.URL;

import static org.apache.commons.io.IOUtils.toByteArray;

public class PlatformInfoAdapter {

    public static PlatformInfo adapt(PlatformInfo info) {
        try {
            info.logo(toBase64(new URL(info.logo())));
        } catch (Exception e) {
            info.logo("");
        }
        return info;
    }

    private static String toBase64(URL resource) throws IOException {
        return "data:image/png;base64," + Base64.encode(toByteArray(resource.openStream()));
    }

}
