package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.helpers.ChartSpecHandler;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.rules.Chart;

import static java.util.Collections.singletonList;
import static java.util.Collections.singletonMap;

public abstract class TimeHistogramDialogDisplay<DN extends DisplayNotifier> extends ChartDialogDisplay<DN, TimeNavigatorDisplay> {
    private final String tag;

    public TimeHistogramDialogDisplay(SumusBox box, Chart type, String tag) {
        super(box, type, new TimeNavigatorDisplay(box));
        this.tag = tag;
    }

    @Override
    protected void init() {
        super.init();
        sendCategorizations();
    }

    public void selectCategorization(String value) {
        ChartSpecHandler chartSpecHandler = chartSpecHandler();
        chartSpecHandler.clearCategorizationsTag(tag);
        chartSpecHandler.selectCategorizations(singletonMap(categorizationOf(value), singletonList(tag)));
        sendCategorization();
        chartSpecHandler.update();
    }

    protected abstract void sendCategorizations();
    protected abstract void sendCategorization();

    protected Categorization categorization() {
        return specification().categorizationList(tag).get(0);
    }

}