package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.builders.NameSpaceBuilder;
import io.intino.sumus.box.displays.notifiers.TabLayoutDisplayNotifier;
import io.intino.sumus.box.schemas.PlatformInfo;
import io.intino.sumus.box.schemas.UserInfo;
import io.intino.sumus.graph.NameSpace;

import java.util.List;

import static java.util.stream.Collectors.toList;

public class TabLayoutDisplay extends LayoutDisplay<TabLayoutDisplayNotifier> {

	public TabLayoutDisplay(SumusBox box) {
		super(box);
	}

	@Override
	protected void refreshSelected(String label) {
		notifier.refreshSelected(label);
	}

	public void logout() {
		super.logout();
	}

	@Override
	public void selectItem(String label) {
		super.openElement(label);
	}

	@Override
	protected void sendLoading() {
		notifier.loading();
	}

	@Override
	protected void sendLoaded() {
		notifier.loaded();
	}

	@Override
	protected void sendUser(UserInfo userInfo) {
		notifier.user(userInfo);
	}

	@Override
	protected void sendInfo(PlatformInfo info) {
		notifier.info(info);
	}

	@Override
	protected void sendItems(List<Item> itemList) {
		notifier.refreshItemList(itemList.stream().map(this::schemaItemOf).collect(toList()));
	}

	@Override
	protected void notifyLoggedOut() {
		notifier.userLoggedOut(session().browser().homeUrl());
	}

	@Override
	protected void refreshNameSpaces(List<NameSpace> nameSpaces) {
		notifier.refreshNameSpaces(NameSpaceBuilder.buildList(nameSpaces));
	}

	@Override
	protected void refreshSelectedNameSpace(NameSpace nameSpace) {
		notifier.refreshSelectedNameSpace(NameSpaceBuilder.build(nameSpace));
	}

	public void selectNameSpace(String value) {
		super.selectNameSpace(value);
	}

}