package io.intino.sumus.box.displays;

import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.builders.CatalogBuilder;
import io.intino.sumus.box.displays.notifiers.ReportCatalogDisplayNotifier;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.TimeScaleHandler;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.tara.magritte.Concept;

import java.util.List;

public class ReportCatalogDisplay extends TemporalCatalogDisplay<ReportCatalogDisplayNotifier, TimeNavigatorDisplay> {

	public ReportCatalogDisplay(SumusBox box) {
		super(box, new TimeNavigatorDisplay(box));
	}

	public void selectGrouping(GroupingSelection value) {
		super.selectGrouping(value);
	}

	@Override
	protected int maxZoom() {
		return 0;
	}

	@Override
	protected void configureTimeScaleHandler(TimeScaleHandler timeScaleHandler, TimeRange range, List<TimeScale> scales) {
		timeScaleHandler.updateInstant(range.to(), scales.get(0));
	}

	@Override
	protected void configureNavigatorDisplay(TimeNavigatorDisplay navigatorDisplay, TimeScaleHandler timeScaleHandler) {
		navigatorDisplay.onMove(this::refresh);
	}

	public void clearFilter() {
		super.clearFilter();
	}

	@Override
	protected void refreshBreadcrumbs(String breadcrumbs) {
		notifier.refreshBreadcrumbs(breadcrumbs);
	}

	@Override
	protected void createPanel(String item) {
		notifier.createPanel(item);
	}

	@Override
	protected void showPanel() {
		notifier.showPanel();
	}

	@Override
	protected void hidePanel() {
		notifier.hidePanel();
	}

	@Override
	protected void sendCatalog() {
		notifier.refreshCatalog(CatalogBuilder.build(element(), manager, label(), embedded()));
	}

	@Override
	protected void showDialog() {
		notifier.showDialog();
	}

	@Override
	protected void notifyFiltered(boolean value) {
		notifier.refreshFiltered(value);
	}

	@Override
	protected Concept recordConcept() {
		return element().asReportHolder().report();
	}

	@Override
	protected void showTimeNavigator() {
		notifier.showTimeNavigator();
	}

	@Override
	protected void addTime(TemporalRecordQuery.Builder builder) {
		TimeRange range = timeScaleHandler().range();
		builder.instant(range.to(), range.scale());
	}

	@Override
	protected <R extends Record> void filterTimezone(RecordList<R> recordList, TimeRange range) {
	}

	@Override
	protected TimeScaleHandler timeScaleHandler() {
		return child(TimeNavigatorDisplay.class).timeScaleHandler();
	}

	@Override
	protected void hideTimeNavigator() {
		notifier.hideTimeNavigator();
	}

	public void timezoneOffset(Integer value) {
		super.timezoneOffset(value);
	}

	public void navigate(String key) {
		super.navigate(key);
	}

}