package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ElementViewDisplay.ExecuteItemTaskEvent;
import io.intino.sumus.box.displays.ElementViewDisplay.OpenItemDialogEvent;
import io.intino.sumus.box.displays.ElementViewDisplay.OpenItemEvent;
import io.intino.sumus.box.displays.providers.ElementViewDisplayProvider;
import io.intino.sumus.graph.*;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class PanelViewDisplay<DN extends DisplayNotifier> extends SumusDisplay<DN> {
	private Panel context;
	private Record target;
	private Panel.View view;
	private ElementViewDisplayProvider provider;
	private List<Consumer<Boolean>> loadingListeners = new ArrayList<>();
	private List<Consumer<OpenItemEvent>> openItemListeners = new ArrayList<>();
	private List<Consumer<OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<>();
	private List<Consumer<ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<>();

	public PanelViewDisplay(SumusBox box) {
		super(box);
	}

	public Panel context() {
		return this.context;
	}

	public void context(Panel context) {
		this.context = context;
	}

	public Record target() {
		return this.target;
	}

	public void target(Record target) {
		this.target = target;
	}

	public Panel.View view() {
		return this.view;
	}

	public void view(Panel.View view) {
		this.view = view;
	}

	public ElementViewDisplayProvider provider() {
		return this.provider;
	}

	public void provider(ElementViewDisplayProvider provider) {
		this.provider = provider;
	}

	public void onLoading(Consumer<Boolean> listener) {
		loadingListeners.add(listener);
	}

	public void onOpenItem(Consumer<OpenItemEvent> listener) {
		openItemListeners.add(listener);
	}

	public void onOpenItemDialog(Consumer<OpenItemDialogEvent> listener) {
		openItemDialogListeners.add(listener);
	}

	public void onExecuteItemTask(Consumer<ExecuteItemTaskEvent> listener) {
		executeItemTaskListeners.add(listener);
	}

	protected void notifyLoading(Boolean value) {
		loadingListeners.forEach(l -> l.accept(value));
	}

	protected void notifyOpenItem(OpenItemEvent params) {
		openItemListeners.forEach(l -> l.accept(params));
	}

	protected void notifyOpenItemDialog(OpenItemDialogEvent params) {
		openItemDialogListeners.forEach(l -> l.accept(params));
	}

	protected void notifyExecuteItemTaskOperation(ExecuteItemTaskEvent params) {
		executeItemTaskListeners.forEach(l -> l.accept(params));
	}

	protected ElementView<Panel> panelViewModelOf(Panel.View view) {
		return new ElementView<Panel>() {
			@Override
			public String name() {
				return view.core$().name();
			}

			@Override
			public String label() {
				return view.label();
			}

			@Override
			public String type() {
				return view.getClass().getSimpleName();
			}

			@Override
			public String option() {
				return null;
			}

			@Override
			public <V extends AbstractView> V raw() {
				return (V) view;
			}

			@Override
			public boolean embeddedElement() {
				return provider.embedded();
			}

			@Override
			public Toolbar toolbar() {
				return element().toolbar();
			}

			@Override
			public int width() {
				return 100;
			}

			@Override
			public Mold mold() {
				ElementRender render = view.elementRender();
				if (render.i$(RenderMold.class)) return render.a$(RenderMold.class).mold();
				return null;
			}

			@Override
			public OnClickRecord onClickRecordEvent() {
				return null;
			}

			@Override
			public boolean canCreateClusters() {
				return false;
			}

			@Override
			public boolean canSearch() {
				return false;
			}

			@Override
			public List<String> clusters() {
				return Collections.emptyList();
			}

			@Override
			public Record target() {
				return target;
			}

			@Override
			public Panel element() {
				return context;
			}

			@Override
			public String emptyMessage() {
				return null;
			}
		};
	}
}
