package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ElementViewDisplay.OpenItemEvent;
import io.intino.sumus.box.displays.notifiers.PanelCatalogViewDisplayNotifier;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.RenderCatalog;

import java.util.Optional;

public class PanelCatalogViewDisplay extends PanelViewDisplay<PanelCatalogViewDisplayNotifier> {

	public PanelCatalogViewDisplay(SumusBox box) {
		super(box);
	}

	@Override
	protected void init() {
		super.init();
		createCatalogDisplay();
	}

	private void createCatalogDisplay() {
		RenderCatalog render = view().elementRender().a$(RenderCatalog.class);
		Catalog catalog = render.catalog();
		buildDisplay(catalog).ifPresent(display -> {
			display.filter(record -> render.filter(context(), target(), (Record) record));
			display.target(target());
			display.nameSpaceHandler(provider().nameSpaceHandler());
			display.catalog(catalog);
			display.onLoading(value -> notifyLoading((Boolean) value));
			display.onOpenItem(params -> notifyOpenItem((OpenItemEvent) params));
			add(display);
			display.personifyOnce(id());
		});
	}

	private Optional<CatalogDisplay> buildDisplay(Catalog catalog) {
		if (catalog.isEventHolder()) return Optional.of(new EventCatalogDisplay(box));
		else if (catalog.isReportHolder()) return Optional.of(new ReportCatalogDisplay(box));
		else if (catalog.isEntityHolder()) return Optional.of(new EntityCatalogDisplay(box));
		return Optional.empty();
	}

}