package io.intino.sumus.box.displays;

import io.intino.sumus.RecordList;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.builders.CatalogBuilder;
import io.intino.sumus.box.displays.notifiers.EntityCatalogDisplayNotifier;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.GroupingGroup;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.queries.CatalogManager;
import io.intino.sumus.queries.EntityQuery;

import java.util.List;

import static java.util.stream.Collectors.toList;

public class EntityCatalogDisplay extends CatalogDisplay<EntityCatalogDisplayNotifier> implements CatalogViewDisplayProvider {

    public EntityCatalogDisplay(SumusBox box) {
        super(box);
    }

    public void selectGrouping(GroupingSelection value) {
        super.selectGrouping(value);
    }

    public void deleteGroupingGroup(GroupingGroup groupingGroup) {
        super.deleteGroupingGroup(groupingGroup);
    }

    public void clearFilter() {
        super.clearFilter();
    }

    @Override
    protected void refreshBreadcrumbs(String breadcrumbs) {
        notifier.refreshBreadcrumbs(breadcrumbs);
    }

    @Override
    protected void createPanel(String item) {
        notifier.createPanel(item);
    }

    @Override
    protected void showPanel() {
        notifier.showPanel();
    }

    @Override
    protected void hidePanel() {
        notifier.hidePanel();
    }

    @Override
    protected void createCatalogManager() {
        RecordList<Entity> recordList = queryEngine().entities(query(null));
        manager = new CatalogManager(recordList.items().stream().map(i -> i.a$(Record.class)).collect(toList()), categorizations(), keys());
    }

    @Override
    protected void sendCatalog() {
        notifier.refreshCatalog(CatalogBuilder.build(element(), manager, label(), embedded()));
    }

    @Override
    protected void showDialog() {
        notifier.showDialog();
    }

    @Override
    protected void notifyFiltered(boolean value) {
        notifier.refreshFiltered(value);
    }

    @Override
    protected void selectNameSpace(NameSpace nameSpace) {
    }

    @Override
    protected <R extends Record> RecordList<R> records(String condition) {
        EntityQuery query = query(condition);
        RecordList<R> recordList = (RecordList<R>) queryEngine().entities(query);
        applyFilter(recordList);
        return recordList;
    }

    @Override
    protected Record loadRecord(String id) {
        return queryEngine().entity(id, username());
    }

    @Override
    protected boolean canCreateClusters() {
        return element().analysis() != null && element().analysis().groupingList().size() > 0;
    }

    private EntityQuery query(String condition) {
        EntityQuery.Builder builder = new EntityQuery.Builder();
        builder.condition(condition);
        builder.filter(scope);
        return builder.build(element().asEntityHolder().entity(), username());
    }

    @Override
    public Record rootRecord(List<Record> recordList) {
        return element().asEntityHolder().rootRecord(recordList, username());
    }

    @Override
    public Record defaultRecord(String name) {
        return element().asEntityHolder().defaultRecord(name, username());
    }

    public void navigate(String key) {
        super.navigate(key);
    }

}