package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.notifiers.CatalogOlapViewDisplayNotifier;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.graph.*;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class CatalogOlapViewDisplay extends SumusDisplay<CatalogOlapViewDisplayNotifier> implements CatalogViewDisplay {
    private ElementView<Catalog> view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<>();

    public CatalogOlapViewDisplay(SumusBox box) {
        super(box);
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<OpenItemDialogEvent> location) {
    }

    @Override
    public void onExecuteItemTask(Consumer<ExecuteItemTaskEvent> params) {
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
    }

    @Override
    public void onOpenItem(Consumer<OpenItemEvent> listener) {
    }

    @Override
    public void reset() {
    }

    @Override
    public ElementView view() {
        return view;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        loadingListeners.add(listener);
    }

    @Override
    public void refresh() {
        super.refresh();
        child(OlapDisplay.class).refresh();
    }

    @Override
    protected void init() {
        super.init();
        buildOlapDisplay();
    }

    private void buildOlapDisplay() {
        OlapDisplay display = new OlapDisplay(box);
        display.nameSpaceHandler(provider.nameSpaceHandler());
        display.olap(olap(view.option()));
        display.onLoading(this::notifyLoading);
        display.onSelect(this::selectInstant);
        display.context(provider.elementType());
        add(display);
        display.personifyOnce();
    }

    private void selectInstant(CatalogInstantBlock block) {
        CatalogDisplay display = provider.openElement(block.catalog());
        List<String> entities = block.entities();
        display.filterAndNotify(record -> entities.contains(((Record)record).core$().id()));
        display.refreshView();
    }

    private Olap olap(String option) {
        return box.graph().olapList().stream()
                .filter(o -> o.name$().equals(option) || o.label().equals(option)).findFirst().orElse(null);
    }

    private void notifyLoading(Boolean loading) {
        loadingListeners.forEach(l -> l.accept(loading));
    }

    @Override
    public void refresh(RecordItem... items) {
    }
}