package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.Category;
import io.intino.sumus.CategoryMap;
import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ElementViewDisplay.OpenItemEvent;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.GroupingGroup;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.*;
import io.intino.sumus.graph.Catalog.Analysis.AbstractGrouping;
import io.intino.sumus.graph.Catalog.Analysis.ClusterGrouping;
import io.intino.sumus.graph.Catalog.Analysis.Grouping;
import io.intino.sumus.graph.Catalog.OlapView;
import io.intino.sumus.graph.entityholder.EntityHolderCatalog;
import io.intino.sumus.graph.eventholder.EventHolderCatalog;
import io.intino.sumus.graph.reportholder.ReportHolderCatalog;
import io.intino.sumus.queries.CatalogManager;
import io.intino.sumus.queries.Scope;
import io.intino.tara.magritte.Concept;

import java.util.*;
import java.util.function.Consumer;

import static io.intino.sumus.graph.Catalog.*;
import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toMap;

public abstract class CatalogDisplay<DN extends DisplayNotifier> extends ElementDisplay<Catalog, DN> implements CatalogViewDisplayProvider {
    private List<Consumer<OpenItemEvent>> openItemListeners = new ArrayList<>();
    protected Map<String, GroupingSelection> groupingSelectionMap = new HashMap<>();
    protected Scope scope = null;
    private String condition = null;
    private RecordList<Record> recordList = null;
    private String currentRecord = null;
    protected CatalogManager manager;

    public CatalogDisplay(SumusBox box) {
        super(box);
    }

    protected List<Categorization> categorizations() {
        if (element().analysis() == null) return emptyList();
        return element().analysis().groupingList().stream().map(Grouping::categorization).collect(toList());
    }

    public boolean isFor(Catalog catalog) {
        return element().name$().equals(catalog.name$());
    }

    public void catalog(Catalog catalog) {
        this.element(catalog);
    }

    public void selectGrouping(GroupingSelection selection) {
        AbstractGrouping abstractGrouping = groupingOf(selection.name());

        if (selection.groups().size() <= 0 ||
            (abstractGrouping.histogram() == AbstractGrouping.Histogram.Absolute && selection.groups().size() <= 0))
            groupingSelectionMap.remove(selection.name());
        else
            groupingSelectionMap.put(selection.name(), selection);

        dirty(true);
        refreshGrouping();
    }

    public void deleteGroupingGroup(GroupingGroup groupingGroup) {
        AbstractGrouping abstractGrouping = groupingOf(groupingGroup.grouping());
        if (!abstractGrouping.i$(ClusterGrouping.class)) return;

        ClusterGrouping grouping = abstractGrouping.a$(ClusterGrouping.class);
        Cluster.Group group = grouping.cluster().groupList().stream().filter(g -> g.name$().equals(groupingGroup.name())).findFirst().orElse(null);
        if (group == null) return;

        group.delete$();
        grouping.cluster().save$();
        sendCatalog();

        if (groupingSelectionMap.containsKey(groupingGroup.grouping())) {
            GroupingSelection groupingSelection = groupingSelectionMap.get(groupingGroup.grouping());
            groupingSelection.groups().remove(group.label());
            selectGrouping(groupingSelection);
        }
    }

    public void refresh(Categorization categorization) {
        sendCatalog();
        currentView().ifPresent(CatalogViewDisplay::refresh);
    }

    @Override
    public Concept elementType() {
        Catalog catalog = element();
        if (catalog.i$(EntityHolderCatalog.class))
            return catalog.a$(EntityHolderCatalog.class).entity();
        if (catalog.i$(EventHolderCatalog.class))
            return catalog.a$(EventHolderCatalog.class).event();
        else if (catalog.i$(ReportHolderCatalog.class))
            return catalog.a$(ReportHolderCatalog.class).report();
        return null;
    }

    @Override
    public int countRecords(String condition) {
        this.updateCondition(condition);
        loadRecordList();
        return recordList.count();
    }

    @Override
    public List<Record> records(int start, int limit, String condition) {
        return records(start, limit, condition, null);
    }

    @Override
    public List<Record> records(int start, int limit, String condition, Sorting sorting) {
        this.updateCondition(condition);
        loadRecordList();
        return recordList.items(start, limit, sorting);
    }

    @Override
    protected Record currentRecord() {
        return record(currentRecord);
    }

    @Override
    protected void currentRecord(String id) {
        this.currentRecord = id;
    }

    @Override
    public Record record(String key) {
        Record record = null;

        if (!dirty() && recordList != null)
            record = recordList.items().stream().filter(r -> r.core$().id().equals(key) || r.core$().name().equals(key)).findFirst().orElse(null);

        return record != null ? record : loadRecord(key);
    }

    @Override
    public List<Catalog.Analysis.Sorting> sortings() {
        if (element().analysis() == null) return emptyList();
        return element().analysis().sortingList();
    }

    @Override
    public Analysis.Sorting sorting(String key) {
        if (element().analysis() == null) return null;
        return element().analysis().sortingList().stream().filter(s -> s.name$().equals(key) || s.label().equals(key)).findFirst().orElse(null);
    }

    public void onOpenItem(Consumer<OpenItemEvent> listener) {
        openItemListeners.add(listener);
    }

    protected void resetGrouping() {
        groupingSelectionMap.clear();
        scope = null;
        queryEngine().filter(scope);
    }

    protected void refreshGrouping() {
        refreshScope();
        queryEngine().filter(scope);
        refreshView();
        sendCatalog();
    }

    @Override
    protected void init() {
        super.init();
        createCatalogManager();
        buildViewList();
        sendCatalog();
        createRecordDisplay();
        createDialogContainer();
    }

    protected ElementView<Catalog> catalogViewOf(AbstractView view) {
        return new ElementView<Catalog>() {
            @Override
            public String name() {
                return view.core$().name();
            }

            @Override
            public String label() {
                return view.label();
            }

            @Override
            public String type() {
                return view.getClass().getSimpleName();
            }

            @Override
            public String option() {
                if (!view.i$(OlapView.class)) return null;
                return view.a$(OlapView.class).olap().name$();
            }

            @Override
            public <V extends AbstractView> V raw() {
                return (V) view;
            }

            @Override
            public boolean embeddedElement() {
                return embedded();
            }

            @Override
            public Toolbar toolbar() {
                return element().toolbar();
            }

            @Override
            public int width() {
                if (view.i$(MagazineView.class)) return view.a$(MagazineView.class).width();
                else if (view.i$(ListView.class)) return view.a$(ListView.class).width();
                else if (view.i$(GridView.class)) return view.a$(GridView.class).width();
                return 100;
            }

            @Override
            public Mold mold() {
                if (view.i$(MagazineView.class)) return view.a$(MagazineView.class).mold();
                else if (view.i$(ListView.class)) return view.a$(ListView.class).mold();
                else if (view.i$(GridView.class)) return view.a$(GridView.class).mold();
                else if (view.i$(MapView.class)) return view.a$(MapView.class).mold();
                return null;
            }

            @Override
            public OnClickRecord onClickRecordEvent() {
                Events events = CatalogDisplay.this.element().events();
                return events != null ? events.onClickRecord() : null;
            }

            @Override
            public boolean canCreateClusters() {
                return CatalogDisplay.this.canCreateClusters();
            }

            @Override
            public boolean canSearch() {
                return CatalogDisplay.this.canSearch();
            }

            @Override
            public List<String> clusters() {
                if (element().analysis() == null) return emptyList();
                return element().analysis().clusterGroupingList().stream().map(AbstractGrouping::label).collect(toList());
            }

            @Override
            public Record target() {
                return CatalogDisplay.this.target();
            }

            @Override
            public Catalog element() {
                return CatalogDisplay.this.element();
            }

            @Override
            public String emptyMessage() {
                if (view.i$(MagazineView.class)) return view.a$(MagazineView.class).noRecordMessage();
                else if (view.i$(ListView.class)) return view.a$(ListView.class).noRecordsMessage();
                else if (view.i$(GridView.class)) return view.a$(GridView.class).noRecordsMessage();
                return null;
            }
        };
    }

    protected abstract void createCatalogManager();

    protected abstract void sendCatalog();

    protected abstract <R extends Record> RecordList<R> records(String condition);

    protected abstract boolean canCreateClusters();

    protected List<ElementView> viewList() {
        return views().stream().map(this::catalogViewOf).collect(toList());
    }

    protected boolean isGrouping(Map.Entry<String, GroupingSelection> entry) {
        return groupingOf(entry.getKey()).i$(Grouping.class);
    }

    protected boolean isCluster(Map.Entry<String, GroupingSelection> entry) {
        return groupingOf(entry.getKey()).i$(ClusterGrouping.class);
    }

    private boolean canSearch() {
        Toolbar toolbar = element().asHolder().toolbar();
        return toolbar == null || toolbar.canSearch();
    }

    private void updateCondition(String condition) {
        if (this.condition != null && !this.condition.equals(condition))
            dirty(true);
        this.condition = condition;
    }

    private void loadRecordList() {
        if (!dirty() && recordList != null) return;
        recordList = CatalogDisplay.this.records(condition);
        dirty(false);
    }

    private void buildViewList() {
        CatalogViewListDisplay display = new CatalogViewListDisplay(box);
        display.recordProvider(this);
        display.viewList(viewList());
        display.onSelectView(this::updateCurrentView);
        display.onOpenItem(this::openItem);
        display.onOpenItemDialog(this::openItemDialog);
        display.onExecuteItemTask(this::executeItemTask);
        display.onLoading(this::notifyLoading);
        display.onCreateCluster(this::refreshCatalog);
        add(display);
        display.personifyOnce();
    }

    @Override
    protected void openItem(OpenItemEvent parameters) {
        if (parameters.panel() == null)
            return;

        if (openItemListeners.size() > 0) {
            openItemListeners.forEach(l -> l.accept(parameters));
            return;
        }

        super.openItem(parameters);
    }

    private void refreshCatalog(Cluster cluster) {
        sendCatalog();
    }

    private void refreshScope() {
        if (groupingSelectionMap.size() <= 0) {
            scope = null;
            return;
        }

        if (scope == null) scope = new Scope();
        manager.clearFilter();
        scope.clear();
        scope.categories(groupingSelectionMap.entrySet().stream().filter(this::isGrouping).collect(toMap(Map.Entry::getKey, e -> categories(e.getValue()))));
        scope.records(groupingSelectionMap.entrySet().stream().filter(this::isCluster).collect(toMap(Map.Entry::getKey, e -> records(e.getValue()))));

        groupingSelectionMap.values().stream()
                                     .filter(g -> groupingOf(g.name()).i$(Grouping.class))
                                     .forEach(selection -> manager.filter(categorizationOf(selection).name$(), selection.groups()));
    }

    private Categorization categorizationOf(GroupingSelection selection) {
        AbstractGrouping abstractGrouping = groupingOf(selection.name());
        if (!abstractGrouping.i$(Grouping.class)) return null;
        return abstractGrouping.a$(Grouping.class).categorization();
    }

    private List<Category> categories(GroupingSelection selection) {
        CategoryMap categoryMap = manager.categories(categorizationOf(selection));
        return categoryMap != null ? selection.groups().stream().map(categoryMap::get).collect(toList()) : emptyList();
    }

    private List<Record> records(GroupingSelection selection) {
        return selection.groups().stream().map(group -> records(selection.name(), group)).flatMap(Collection::stream).collect(toList());
    }

    private List<Record> records(String groupingName, String groupName) {
        AbstractGrouping grouping = groupingOf(groupingName);
        return recordsOf(grouping, groupName);
    }

    private List<Record> recordsOf(AbstractGrouping grouping, String groupLabel) {
        ClusterGrouping clusterGrouping = grouping.a$(ClusterGrouping.class);
        Cluster.Group group = clusterGrouping.cluster().groupList().stream().filter(g -> g.label().equals(groupLabel)).findFirst().orElse(null);
        return group != null ? group.entities().stream().map(e -> e.a$(Record.class)).collect(toList()) : emptyList();
    }

    private AbstractGrouping groupingOf(String groupingName) {
        if (element().analysis() == null) return null;
        return element().analysis().abstractGroupingList().stream().filter(g -> g.name$().equals(groupingName)).findFirst().orElse(null);
    }

    private void createRecordDisplay() {
        RecordDisplay display = new RecordDisplay(box);
        add(display);
        display.personifyOnce();
    }

}