package io.intino.sumus.box;

import amidas.proxy.konos.core.AmidasKonosAccessor;
import io.intino.konos.server.activity.displays.Soul;
import io.intino.konos.server.activity.services.auth.Space;
import io.intino.sumus.Settings;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.providers.StampDisplayProvider;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.helpers.TranslatorHelper;
import io.intino.tara.magritte.Graph;

import java.util.Collection;

public class SumusBox extends AbstractBox {
	private SumusGraph sumusGraph;
	private Settings settings;
	private TranslatorHelper translatorHelper;
	private StampDisplayProvider stampDisplayProvider = null;

	public SumusBox(String[] args) {
		super(args);
	}

	public SumusBox(SumusConfiguration configuration) {
		super(configuration);
		this.settings = new Settings(configuration.args());
	}

	@Override
	public io.intino.konos.Box put(Object o) {
		if (o instanceof Graph) this.sumusGraph = ((Graph) o).as(SumusGraph.class);
		if (o instanceof TranslatorHelper) this.translatorHelper = (TranslatorHelper) o;
		return this;
	}

	public io.intino.konos.Box open() {
		this.translatorHelper = new TranslatorHelper(sumusGraph);
		super.open();
		graph().init();
		return this;
	}

	public SumusGraph graph() {
		return sumusGraph;
	}

	public Settings actionsConfiguration() {
		return settings;
	}

	public void close() {
		super.close();
	}

	public TranslatorHelper translatorHelper() {
		return translatorHelper;
	}

	public void refreshDisplaysOf(Catalog catalog, Categorization categorization) {
		activitySouls.values().stream().map(Soul::getAll).flatMap(Collection::stream)
				.filter(d -> d instanceof CatalogDisplay && ((CatalogDisplay) d)
						.isFor(catalog)).forEach(d -> ((CatalogDisplay) d).refresh(categorization));
	}

	public <R extends Record> void refreshDisplaysOf(Catalog catalog, boolean categorizationsHaveChanges, R... records) {
		activitySouls.values().stream().map(Soul::getAll).flatMap(Collection::stream)
				.filter(d -> d instanceof CatalogDisplay && ((CatalogDisplay) d)
						.isFor(catalog)).forEach(d -> {
			CatalogDisplay display = (CatalogDisplay) d;
			display.dirty(true);
			if (categorizationsHaveChanges || records.length == 0)
				display.refresh();
			else
				display.refresh(records);
		});
	}

	public StampDisplayProvider stampDisplayProvider() {
		return this.stampDisplayProvider;
	}

	public void stampDisplayProvider(StampDisplayProvider provider) {
		this.stampDisplayProvider = provider;
	}

	static io.intino.konos.server.activity.services.AuthService authService(java.net.URL authServiceUrl) {
		return authServiceUrl != null ? new AmidasKonosAccessor(new Space(authServiceUrl), authServiceUrl) : null;
	}

}