package io.intino.sumus.box;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import static org.slf4j.Logger.ROOT_LOGGER_NAME;

import io.intino.konos.server.activity.displays.Soul;

public abstract class AbstractBox extends io.intino.konos.Box {
	private static Logger logger = LoggerFactory.getLogger(ROOT_LOGGER_NAME);
	protected SumusConfiguration configuration;
    protected Map<String, Soul> activitySouls = new java.util.HashMap<>();

	public AbstractBox(String[] args) {
		this(new SumusConfiguration(args));
	}

	public AbstractBox(SumusConfiguration configuration) {

		this.configuration = configuration;
		if (configuration().platformConfiguration != null)
			io.intino.konos.server.activity.ActivityKonosSpark.setup(configuration().platformConfiguration.port, configuration().platformConfiguration.webDirectory, configuration().platformConfiguration.authService);
	}

	public SumusConfiguration configuration() {
		return (SumusConfiguration) configuration;
	}

	@Override
	public io.intino.konos.Box put(Object o) {

		return this;
	}

	public io.intino.konos.Box open() {
		if(owner != null) owner.open();
		initActivities();
		initRESTServices();
		initJMXServices();
		initJMSServices();
		initDataLake();
		initTasks();
		initSlackBots();
		return this;
	}

	public void close() {
		if(owner != null) owner.close();
		io.intino.konos.server.activity.ActivityKonosSpark.instance().stop();


	}

	public void registerSoul(String clientId, Soul soul) {

	activitySouls.put(clientId, soul);
}

public void unRegisterSoul(String clientId) {

	activitySouls.remove(clientId);
}







	private void initRESTServices() {

	}

	private void initJMSServices() {


	}

	private void initJMXServices() {

	}

	private void initSlackBots() {

	}

	private void initActivities() {
		if (configuration().platformConfiguration == null) return;
		PlatformActivity.init(io.intino.konos.server.activity.ActivityKonosSpark.instance(), (SumusBox) this).start();
		logger.info("Activity Platform: started!");
	}

	private void initDataLake() {

	}

	private void initTasks() {

	}

	private void initLogger() {
		final java.util.logging.Logger logger = java.util.logging.Logger.getGlobal();
		final ConsoleHandler handler = new ConsoleHandler();
		handler.setLevel(Level.INFO);
		handler.setFormatter(new io.intino.konos.LogFormatter("log"));
		logger.addHandler(handler);
	}
}