package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.graph.*;

import java.util.List;

public interface ElementView<E extends Element> {
    String name();
    String label();
    String type();
    String option();
    <V extends AbstractView> V raw();
    boolean embeddedElement();
    Toolbar toolbar();
    int width();
    Mold mold();
    OnClickRecord onClickRecordEvent();
    boolean canCreateClusters();
    boolean canSearch();
    List<String> clusters();
    Record target();
    E element();
    String emptyMessage();
}
