package io.intino.sumus.analytics.categorization.temporal;

import io.intino.sumus.graph.Categorization;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.graph.rules.TimeScale;

import static io.intino.sumus.graph.rules.TimeScale.Month;

public class MonthCategorization extends TemporalCategorization {

    public MonthCategorization(TimeRange range) {
        super("MonthCategorization", "Month", parent(range), new TimeRange(range.from(), range.to(), Month));
    }

    private static Categorization parent(TimeRange range) {
        return new TemporalCategorization(new TimeRange(range.from(), range.to(), TimeScale.QuarterOfYear));
    }

}
