package io.intino.sumus;

import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider.Sorting;
import io.intino.sumus.graph.Record;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RecordList<T extends Record> {
	private List<T> records;
	private Sorting sorting = null;

	public RecordList(List<T> records) {
		this.records = records;
	}

	public int count() {
		return records.size();
	}

	public void filter(Function<Record, Boolean> filter) {
		records = records.stream().filter(filter::apply).collect(Collectors.toList());
	}

	public RecordList<T> sort(Sorting sorting) {
		if (sorting == null || this.sorting == sorting) return this;

		this.sorting = sorting;
		records.sort(sorting::comparator);

		if (sorting.mode() == Sorting.Mode.Descendant)
			Collections.reverse(records);

		return this;
	}

	public List<T> items() {
		return records;
	}

	public List<T> items(int start, int limit) {
		int end = start + limit;
		if (end > records.size()) end = records.size();
		return records.subList(start, end);
	}

	public List<T> items(int start, int limit, Sorting sorting) {
		sort(sorting);
		return items(start, limit);
	}
}
