/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.temporalrecord;

import io.intino.sumus.Category;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.queries.Filter;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import java.time.Instant;

public class Query {
    private final Concept temporalRecord;
    private final NameSpace nameSpace;
    private final TimeStamp timeStamp;
    private Filter filter;
    private String condition;

    public Query(NameSpace nameSpace, Concept temporalRecord, TimeStamp timeStamp) {
        this.temporalRecord = temporalRecord;
        this.nameSpace = nameSpace;
        this.timeStamp = timeStamp;
    }

    public Query(NameSpace nameSpace, Concept temporalRecord, TimeScale scale, Instant instant) {
        this(nameSpace, temporalRecord, new TimeStamp(instant, scale));
    }

    public Query(NameSpace nameSpace, Class<? extends Layer> recordClass, TimeStamp timeStamp) {
        this(nameSpace, nameSpace.core$().graph().concept(recordClass), timeStamp);
    }

    public Query(NameSpace nameSpace, Class<? extends Layer> recordClass, TimeScale scale, Instant instant) {
        this(nameSpace, recordClass, new TimeStamp(instant, scale));
    }

    public Query filter(Category ... categories) {
        this.filter = this.filter == null ? new Filter() : this.filter;
        this.filter.add(categories);
        return this;
    }

    public Query filter(Record ... records) {
        Category category = new Category("Custom Filter");
        for (Record record : records) {
            category.recordIds().add(record.core$().id());
        }
        this.filter(category);
        return this;
    }

    public Concept temporalRecord() {
        return this.temporalRecord;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public TimeStamp timeStamp() {
        return this.timeStamp;
    }

    public Filter filter() {
        return this.filter;
    }

    public String condition() {
        return this.condition;
    }

    public Query condition(String condition) {
        this.condition = condition;
        return this;
    }
}

