/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.temporalrecord;

import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CategorizationSeeker {
    public static List<Categorization> categorizationsOf(NameSpace nameSpace, Concept temporalRecord, TimeScale scale, Instant instant) {
        return CategorizationSeeker.categorizationsOf(nameSpace, temporalRecord, new TimeStamp(instant, scale));
    }

    public static List<Categorization> categorizationsOf(NameSpace nameSpace, Concept temporalRecord, TimeStamp timeStamp) {
        List<TemporalRecord> temporalRecords = CategorizationSeeker.temporalRecords(temporalRecord, nameSpace, timeStamp);
        if (temporalRecords.isEmpty()) {
            return Collections.emptyList();
        }
        List<Record> records = CategorizationSeeker.recordsOf(temporalRecords.get(0));
        return nameSpace.graph().categorizationList(c -> CategorizationSeeker.canBeUsedOn(records, c)).collect(Collectors.toList());
    }

    public static List<Record> recordsOf(TemporalRecord record) {
        return record.core$().variables().values().stream().filter(CategorizationSeeker::isDimension).map(CategorizationSeeker::toRecord).collect(Collectors.toList());
    }

    private static List<TemporalRecord> temporalRecords(Concept temporalRecord, NameSpace nameSpace, TimeStamp timeStamp) {
        Graph graph = nameSpace.graph().core$().clone();
        graph.loadStashes(new String[]{PathBuilder.temporalRecordPath(nameSpace, temporalRecord, timeStamp)});
        return graph.rootList(TemporalRecord.class);
    }

    private static boolean isDimension(List<?> varValues) {
        return !varValues.isEmpty() && varValues.get(0) instanceof Layer && ((Layer)varValues.get(0)).i$(Entity.class);
    }

    private static Record toRecord(List<?> varValues) {
        return (Record)((Layer)varValues.get(0)).a$(Record.class);
    }

    private static boolean canBeUsedOn(List<Record> records, Categorization categorization) {
        for (Record record : records) {
            if (!record.i$(categorization.record())) continue;
            return true;
        }
        return false;
    }
}

