/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.Category;
import io.intino.sumus.QueryEngine;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.Scaler;
import io.intino.sumus.analytics.viewmodels.Serie;
import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.MathHelper;
import io.intino.sumus.helpers.QueryHelper;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.TimeSeriesQuery;
import io.intino.sumus.queries.digest.Query;
import io.intino.sumus.queries.digest.QueryExecutor;
import io.intino.sumus.queries.digest.QueryResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExportDocumentHelper
extends QueryHelper {
    private final Map<String, Scaler> scalers = new HashMap<String, Scaler>();

    public List<QueryEngine.DocumentRow> execute(TimeSeriesQuery timeSeriesQuery) {
        Query query = this.queryOf(timeSeriesQuery);
        QueryResult rawData = QueryExecutor.execute(query);
        ArrayList<Serie> serieList = new ArrayList<Serie>();
        query.nameSpaces().forEach(nameSpace -> query.formulas().forEach(formula -> {
            if (query.drills().isEmpty()) {
                serieList.add(this.createSerie((MeasureIndicator.Formula)((Object)((Object)formula)), query, rawData.values((NameSpace)((Object)nameSpace), (MeasureIndicator.Formula)((Object)((Object)formula)))));
            }
            query.drills().forEach(drill -> serieList.add(this.createSerie((MeasureIndicator.Formula)((Object)((Object)formula)), query, rawData.values((NameSpace)((Object)nameSpace), (MeasureIndicator.Formula)((Object)((Object)formula)), (Drill)drill), (Drill)drill)));
        }));
        return this.toDocument(serieList, timeSeriesQuery);
    }

    private List<QueryEngine.DocumentRow> toDocument(List<Serie> serieList, TimeSeriesQuery timeSeriesQuery) {
        Comparator<QueryEngine.DocumentRow> byInstant = Comparator.comparing(r -> r.internalInstant);
        Comparator<QueryEngine.DocumentRow> byTicket = Comparator.comparing(r -> r.indicator);
        Comparator<QueryEngine.DocumentRow> byInstantAndTicket = byInstant.thenComparing(byTicket);
        ArrayList rows = new ArrayList();
        serieList.forEach(serie -> serie.values().entrySet().stream().map(e -> rows.add(this.buildRow((Map.Entry<Instant, Double>)e, this.unitLabelOf((Serie)serie), Collections.emptyMap(), (Serie)serie, timeSeriesQuery))));
        return rows.stream().sorted(byInstantAndTicket).collect(Collectors.toList());
    }

    private Serie createSerie(MeasureIndicator.Formula formula, Query query, Map<TimeStamp, Double> values) {
        TimeStamp timeStamp = query.timeStamps().get(0);
        return this.createSerie(formula, query, this.labelOf(formula), this.colorOf(this.indicatorOf(formula)), values);
    }

    private Serie createSerie(MeasureIndicator.Formula formula, Query query, Map<TimeStamp, Double> values, Drill drill) {
        int drillIndex = this.drillIndexOf(drill, query);
        return this.createSerie(formula, query, this.labelOf(formula, drill), this.colorOf(this.indicatorOf(formula), drillIndex), values);
    }

    private Serie createSerie(MeasureIndicator.Formula formula, Query query, String label, String color, Map<TimeStamp, Double> values) {
        Ticket ticket = this.ticketOf(formula);
        Serie serie = new Serie(ticket, this.indicatorOf(formula), label, color);
        boolean fillWithZeros = ticket.style().line() == Ticket.Style.Line.ContinuousWithZeros;
        query.timeStamps().forEach(timeStamp -> {
            if (!values.containsKey(timeStamp) && !fillWithZeros) {
                return;
            }
            serie.register(timeStamp.instant(), fillWithZeros ? 0.0 : (Double)values.get(timeStamp));
        });
        this.scalers.put(serie.label(), this.scaler(serie));
        serie.scaleValues(this.scalers.get(serie.label()));
        return serie;
    }

    private String unitLabelOf(Serie indicator) {
        return this.scalers.get(indicator.label()).unitLabel();
    }

    private QueryEngine.DocumentRow buildRow(Map.Entry<Instant, Double> entryValue, String unitLabel, Map<Categorization, Category> drill, Serie indicator, TimeSeriesQuery query) {
        Double value = entryValue.getValue();
        if (indicator.decimalPlaces().absolute() != 0) {
            value = MathHelper.round(value, indicator.decimalPlaces().absolute());
        }
        return new QueryEngine.DocumentRow(entryValue.getKey(), indicator.label(), drill, query.filters(), value, unitLabel, query.timeRange().scale());
    }

    private Scaler scaler(Serie indicator) {
        return this.scaler(indicator, indicator.maxValue());
    }

    private Scaler scaler(Serie indicator, double maxValue) {
        this.scalers.putIfAbsent(indicator.label(), ((AbstractMetric)indicator.unit().core$().ownerAs(AbstractMetric.class)).scaler().scaler(maxValue, indicator.unit()));
        return this.scalers.get(indicator.label());
    }

    private Query queryOf(TimeSeriesQuery query) {
        return query.toRawQuery((tickets, range) -> this.formulas(this.measureIndicators(query.tickets(), query.timeRange())));
    }
}

