/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.Category;
import io.intino.sumus.RecordList;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.Record;
import io.intino.sumus.helpers.Helper;
import io.intino.sumus.queries.EntityQuery;
import io.intino.sumus.queries.Scope;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EntityHelper
extends Helper {
    private final SumusBox box;

    public EntityHelper(SumusBox box) {
        this.box = box;
    }

    public RecordList<Entity> entities(EntityQuery query) {
        return new RecordList<Entity>(this.load(query));
    }

    public Entity entity(String id) {
        return (Entity)this.box.graph().core$().load(id).as(Entity.class);
    }

    private List<Entity> load(EntityQuery query) {
        Concept entity = query.entity();
        Optional<Scope> scope = query.scope();
        return this.box.graph().core$().find(entity.layerClass()).stream().filter(e -> !scope.isPresent() || this.conforms((Layer)e, (Scope)scope.get())).filter(e -> this.hasCondition((Layer)e, query.condition())).map(e -> (Entity)e.a$(Entity.class)).collect(Collectors.toList());
    }

    private boolean hasCondition(Layer entity, String condition) {
        if (condition == null || condition.isEmpty()) {
            return true;
        }
        List<String> keys = Arrays.asList(condition.toLowerCase().split(" "));
        List<String> words = this.words(entity);
        return keys.stream().filter(key -> words.stream().filter(word -> word.toLowerCase().contains((CharSequence)key)).count() > 0L).count() == (long)keys.size();
    }

    private List<String> words(Layer entity) {
        List values = entity.core$().variables().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<String> words = values.stream().filter(v -> v instanceof String).map(v -> (String)v).collect(Collectors.toList());
        values.stream().filter(v -> v instanceof Layer).map(v -> (Layer)v).forEach(e -> words.addAll(this.words((Layer)e)));
        return words;
    }

    private boolean conforms(Layer entity, Scope scope) {
        List entities = entity.core$().variables().values().stream().flatMap(Collection::stream).filter(s -> s instanceof Entity).map(s -> ((Entity)((Object)((Object)s))).core$().id()).collect(Collectors.toList());
        List<List<String>> records = this.records(scope);
        for (List<String> recordList : records) {
            if (recordList.contains(entity.core$().id())) continue;
            recordList.retainAll(entities);
            if (recordList.size() > 0) continue;
            return false;
        }
        return true;
    }

    private List<List<String>> records(Scope scope) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        scope.categories().forEach(categoryList -> result.add(this.recordsOfCategories((List<Category>)categoryList)));
        scope.records().forEach(recordList -> result.add(this.records((List<Record>)recordList)));
        return result;
    }

    private List<String> recordsOfCategories(List<Category> categories) {
        return categories.stream().map(Category::recordIds).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> records(List<Record> recordList) {
        return recordList.stream().map(r -> r.core$().id()).collect(Collectors.toList());
    }
}

