/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class KeyStore
extends Layer
implements Terminal {
    protected List<Key> keyList = new ArrayList<Key>();

    public KeyStore(Node node) {
        super(node);
    }

    public List<Key> keyList() {
        return Collections.unmodifiableList(this.keyList);
    }

    public Key key(int index) {
        return this.keyList.get(index);
    }

    public List<Key> keyList(Predicate<Key> predicate) {
        return this.keyList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Key>(this.keyList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("KeyStore$Key")) {
            this.keyList.add((Key)node.as(Key.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("KeyStore$Key")) {
            this.keyList.remove(node.as(Key.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Key
    extends Layer
    implements Terminal {
        protected String pattern;
        protected String username;

        public Key(Node node) {
            super(node);
        }

        public String pattern() {
            return this.pattern;
        }

        public String username() {
            return this.username;
        }

        public Key pattern(String value) {
            this.pattern = value;
            return this;
        }

        public Key username(String value) {
            this.username = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("pattern", new ArrayList<String>(Collections.singletonList(this.pattern)));
            map.put("username", new ArrayList<String>(Collections.singletonList(this.username)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("pattern")) {
                this.pattern = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("username")) {
                this.username = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("pattern")) {
                this.pattern = (String)values.get(0);
            } else if (name.equalsIgnoreCase("username")) {
                this.username = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void key(Predicate<Key> filter) {
            new ArrayList<Key>(KeyStore.this.keyList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Key key(String pattern, String username) {
            Key newElement = (Key)KeyStore.this.core$().graph().concept(Key.class).createNode(this.name, KeyStore.this.core$()).as(Key.class);
            newElement.core$().set((Layer)newElement, "pattern", Collections.singletonList(pattern));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }
    }
}

