/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.requesters;

import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.konos.server.activity.spark.ActivitySparkManager;
import io.intino.konos.server.activity.spark.resources.DisplayRequester;
import io.intino.sumus.box.displays.CatalogListViewDisplay;
import io.intino.sumus.box.schemas.CatalogOperationParameters;
import io.intino.sumus.box.schemas.ClusterGroup;
import io.intino.sumus.box.schemas.DownloadItemParameters;
import io.intino.sumus.box.schemas.OpenItemDialogParameters;
import io.intino.sumus.box.schemas.Sorting;

public class CatalogListViewDisplayRequester
extends DisplayRequester {
    public CatalogListViewDisplayRequester(ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    public void execute() throws KonosException {
        CatalogListViewDisplay display = (CatalogListViewDisplay)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("selection")) {
            display.selection((String[])this.manager.fromQuery("value", String[].class));
        } else if (operation.equals("renderExpandedPictures")) {
            display.renderExpandedPictures();
        } else if (operation.equals("itemRefreshed")) {
            display.itemRefreshed((String)this.manager.fromQuery("value", String.class));
        } else if (operation.equals("selectSorting")) {
            display.selectSorting((Sorting)this.manager.fromQuery("value", Sorting.class));
        } else if (operation.equals("page")) {
            display.page((Integer)this.manager.fromQuery("value", Integer.class));
        } else if (operation.equals("filter")) {
            display.filter((String)this.manager.fromQuery("value", String.class));
        } else if (operation.equals("createClusterGroup")) {
            display.createClusterGroup((ClusterGroup)this.manager.fromQuery("value", ClusterGroup.class));
        } else if (operation.equals("executeOperation")) {
            display.executeOperation((CatalogOperationParameters)this.manager.fromQuery("value", CatalogOperationParameters.class));
        } else if (operation.equals("downloadOperation")) {
            ActivityFile file = display.downloadOperation((CatalogOperationParameters)this.manager.fromQuery("value", CatalogOperationParameters.class));
            this.manager.write((Object)file.content(), file.label());
        } else if (operation.equals("openItemDialogOperation")) {
            display.openItemDialogOperation((OpenItemDialogParameters)this.manager.fromQuery("value", OpenItemDialogParameters.class));
        } else if (operation.equals("downloadItemOperation")) {
            ActivityFile file = display.downloadItemOperation((DownloadItemParameters)this.manager.fromQuery("value", DownloadItemParameters.class));
            this.manager.write((Object)file.content(), file.label());
        }
    }
}

