/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.schemas.Item;
import io.intino.sumus.box.schemas.ItemProperty;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Filter;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.entitycontainer.EntityContainerCatalog;
import io.intino.sumus.graph.eventcontainer.EventContainerCatalog;
import io.intino.sumus.graph.reportcontainer.ReportContainerCatalog;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ItemBuilder {
    public static <T extends Categorization> Item build(T categorization) {
        return new Item().name(categorization.name$()).label(categorization.label());
    }

    public static <T extends Categorization> List<Item> buildList(List<T> categorizationList) {
        return categorizationList.stream().map(ItemBuilder::build).collect(Collectors.toList());
    }

    public static Item build(Catalog catalog) {
        return new Item().name(catalog.name$()).label(catalog.label()).itemPropertyList(Collections.singletonList(new ItemProperty().name("type").value(ItemBuilder.catalogType(catalog))));
    }

    private static String catalogType(Catalog catalog) {
        if (catalog.i$(EntityContainerCatalog.class)) {
            return "entity";
        }
        if (catalog.i$(EventContainerCatalog.class)) {
            return "event";
        }
        if (catalog.i$(ReportContainerCatalog.class)) {
            return "report";
        }
        return "";
    }

    public static List<Item> buildCatalogList(List<Catalog> catalogList) {
        return catalogList.stream().map(ItemBuilder::build).collect(Collectors.toList());
    }

    public static Item build(Olap olap) {
        return new Item().name(olap.name$()).label(olap.label());
    }

    public static List<Item> buildOlapList(List<Olap> olapList) {
        return olapList.stream().map(ItemBuilder::build).collect(Collectors.toList());
    }

    public static Item build(Filter filter) {
        return new Item().name(filter.name$()).label(filter.label());
    }

    public static List<Item> buildFilterList(List<Filter> filterList) {
        return filterList.stream().map(ItemBuilder::build).collect(Collectors.toList());
    }

    public static Item build(CatalogView view) {
        return new Item().name(view.name()).label(view.label()).itemPropertyList(Collections.singletonList(new ItemProperty().name("type").value(view.type())));
    }

    public static List<Item> buildCatalogViewList(List<CatalogView> viewList) {
        return viewList.stream().map(ItemBuilder::build).collect(Collectors.toList());
    }
}

