/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.displays.TemporalStampDisplay;
import io.intino.sumus.box.displays.TimeNavigatorDisplay;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.rules.Mode;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.graph.temporalcontainer.TemporalContainerCatalog;
import io.intino.sumus.helpers.Bounds;
import io.intino.sumus.helpers.TimeScaleHandler;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.tara.magritte.Concept;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;

public abstract class TemporalCatalogDisplay<C extends TemporalContainerCatalog, DN extends DisplayNotifier>
extends CatalogDisplay<C, DN> {
    private TimeRange range;
    private NameSpace nameSpace = null;

    public TemporalCatalogDisplay(SumusBox box) {
        super(box);
    }

    public void nameSpace(NameSpace nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    protected StampDisplay display(String stamp) {
        if (this.stampDisplayProvider == null) {
            return null;
        }
        TemporalStampDisplay display = this.stampDisplayProvider.temporalDisplay(stamp);
        display.nameSpace(this.nameSpace());
        display.scale(this.timeScaleHandler().range().scale());
        display.instant(this.timeScaleHandler().range().to());
        return display;
    }

    public NameSpace nameSpace() {
        return this.nameSpace != null ? this.nameSpace : (this.catalog != null ? ((TemporalContainerCatalog)this.catalog).nameSpace() : null);
    }

    @Override
    public void selectGrouping(GroupingSelection value) {
        super.selectGrouping(value);
    }

    @Override
    public void refreshView() {
        super.refreshView();
        this.currentView().ifPresent(catalogView -> {
            Catalog.View view = ((TemporalContainerCatalog)this.catalog).viewList().stream().filter(v -> v.name$().equals(catalogView.view().name())).findFirst().orElse(null);
            if (view != null && view.i$(Catalog.OlapView.class)) {
                this.hideTimeNavigator();
            } else {
                this.showTimeNavigator();
            }
        });
    }

    @Override
    protected <R extends Record> RecordList<R> records(String condition) {
        TemporalRecordQuery query = this.query(condition);
        if (!this.equalsRange()) {
            this.resetGrouping();
        }
        RecordList<TemporalRecord> recordList = this.queryEngine().temporalRecords(query);
        if (!this.equalsRange()) {
            this.reloadGroupings(recordList.items());
        }
        this.range = this.timeScaleHandler().range();
        return recordList;
    }

    @Override
    protected Record record(String id) {
        return this.queryEngine().temporalRecord(id);
    }

    @Override
    protected boolean canCreateClusters() {
        return false;
    }

    @Override
    protected void init() {
        TimeScaleHandler timeScaleHandler = this.buildTimeScaleHandler();
        this.buildTimeNavigator(timeScaleHandler);
        super.init();
    }

    private void buildTimeNavigator(TimeScaleHandler timeScaleHandler) {
        TimeNavigatorDisplay display = new TimeNavigatorDisplay(this.box);
        display.timeScaleHandler(timeScaleHandler);
        display.onMove(this::refresh);
        this.addAndPersonify(display);
    }

    private void refresh(Instant instant) {
        this.refreshView();
    }

    private TimeScaleHandler buildTimeScaleHandler() {
        TimeRange range = this.queryEngine().temporalRecordRange(this.nameSpace());
        TimeScaleHandler.Bounds bounds = new TimeScaleHandler.Bounds();
        List<TimeScale> scales = ((TemporalContainerCatalog)this.catalog).scales();
        HashMap<TimeScale, Bounds.Zoom> zoomMap = new HashMap<TimeScale, Bounds.Zoom>();
        bounds.range(new TimeRange(range.from(), range.to(), TimeScale.Minute));
        bounds.mode(Mode.ToTheLast);
        scales.forEach(scale -> zoomMap.put((TimeScale)((Object)scale), new Bounds.Zoom().min(0).max(200)));
        bounds.zooms(zoomMap);
        TimeScaleHandler timeScaleHandler = new TimeScaleHandler(bounds, scales, scales.get(0));
        timeScaleHandler.availableScales(this.localizedScales(scales));
        timeScaleHandler.updateInstant(range.to(), scales.get(0));
        return timeScaleHandler;
    }

    @Override
    protected TimeScale scale() {
        return this.timeScaleHandler().range().scale();
    }

    @Override
    protected boolean dirty() {
        return super.dirty() || !this.equalsRange();
    }

    protected boolean equalsRange() {
        TimeRange range = this.timeScaleHandler().range();
        return this.range != null && this.range.from() == range.from() && this.range.scale() == range.scale();
    }

    private TemporalRecordQuery query(String condition) {
        TimeRange range = this.timeScaleHandler().range();
        TemporalRecordQuery.Builder builder = new TemporalRecordQuery.Builder();
        builder.condition(condition);
        builder.timeRange(range);
        builder.nameSpace(this.nameSpace());
        return builder.build(this.recordConcept());
    }

    private TimeScaleHandler timeScaleHandler() {
        return ((TimeNavigatorDisplay)this.child(TimeNavigatorDisplay.class)).timeScaleHandler();
    }

    private void reloadGroupings(List<? extends Record> records) {
        ((TemporalContainerCatalog)this.catalog).groupingList().forEach(g -> g.categorization().refresh(records));
        this.sendCatalog();
    }

    protected abstract Concept recordConcept();

    protected abstract void hideTimeNavigator();

    protected abstract void showTimeNavigator();
}

