/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.services.push.User;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.notifiers.FilterListDisplayNotifier;
import io.intino.sumus.box.schemas.FilterDialog;
import io.intino.sumus.graph.Filter;
import io.intino.sumus.graph.SumusGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FilterListDisplay
extends SumusDisplay<FilterListDisplayNotifier> {
    private List<Filter> filterList = null;
    private List<Consumer<Filter>> selectListeners = new ArrayList<Consumer<Filter>>();
    private List<Consumer<Filter>> applyListeners = new ArrayList<Consumer<Filter>>();
    private List<Consumer<Filter>> quitListeners = new ArrayList<Consumer<Filter>>();
    private List<Consumer<Filter>> removeListeners = new ArrayList<Consumer<Filter>>();
    private Filter selected = null;
    private List<String> appliedList = new ArrayList<String>();

    public FilterListDisplay(SumusBox box) {
        super(box);
    }

    public void onSelect(Consumer<Filter> listener) {
        this.selectListeners.add(listener);
    }

    public void onApply(Consumer<Filter> listener) {
        this.applyListeners.add(listener);
    }

    public void onQuit(Consumer<Filter> listener) {
        this.quitListeners.add(listener);
    }

    public void onRemoveFilter(Consumer<Filter> listener) {
        this.removeListeners.add(listener);
    }

    public List<Filter> filterList() {
        if (this.filterList == null) {
            this.filterList = this.loadFilterList();
        }
        return this.filterList;
    }

    protected void init() {
        super.init();
        this.sendFilterList();
    }

    public void refresh() {
        super.refresh();
        this.reload();
    }

    public void selectFilter(String name) {
        Filter filter = this.filterList().stream().filter(f -> f.name$().equals(name)).findFirst().orElse(null);
        if (this.selected != null && this.selected == filter) {
            return;
        }
        this.selected = filter;
        ((FilterListDisplayNotifier)this.notifier).refreshSelected(filter.name$());
        this.selectListeners.forEach(l -> l.accept(filter));
    }

    public void applyFilter(String name) {
        this.selectFilter(name);
        Filter filter = this.filterList().stream().filter(f -> f.name$().equals(name)).findFirst().orElse(null);
        this.applyListeners.forEach(l -> l.accept(filter));
        this.appliedList.add(name);
        ((FilterListDisplayNotifier)this.notifier).refreshApplied(this.appliedList);
    }

    public void quitFilter(String name) {
        this.selectFilter(name);
        Filter filter = this.filterList().stream().filter(f -> f.name$().equals(name)).findFirst().orElse(null);
        this.quitListeners.forEach(l -> l.accept(filter));
        this.appliedList.remove(name);
        ((FilterListDisplayNotifier)this.notifier).refreshApplied(this.appliedList);
    }

    public void addFilter() {
        SumusGraph sumus = this.box.graph();
        User user = this.session().user();
        Filter filter = sumus.create("filters").filter("", user != null ? user.username() : null);
        this.reload();
        this.selectFilter(filter.name$());
    }

    public void saveFilter(FilterDialog dialog) {
        Filter filter = this.filterOf(dialog.filter());
        filter.label(dialog.label());
        filter.save$();
    }

    public void removeFilter(String name) {
        Filter filter = this.filterOf(name);
        filter.delete$();
        this.removeListeners.forEach(l -> l.accept(filter));
        this.reload();
        if (this.filterList().size() > 0) {
            this.selectFilter(this.filterList.get(0).name$());
        }
    }

    private void sendFilterList() {
        ((FilterListDisplayNotifier)this.notifier).refreshFilterList(ItemBuilder.buildFilterList(this.filterList()));
    }

    private List<Filter> loadFilterList() {
        User user = this.session().user();
        SumusGraph sumus = this.box.graph();
        return sumus.filterList().stream().filter(f -> this.userComposesFilter(user, (Filter)((Object)f))).collect(Collectors.toList());
    }

    private boolean userComposesFilter(User user, Filter filter) {
        return user == null && filter.username() == null || user != null && user.username().equals(filter.username());
    }

    private void reload() {
        this.filterList = null;
        this.selected = null;
        this.sendFilterList();
    }

    private Filter filterOf(String filter) {
        return this.filterList().stream().filter(f -> f.name$().equals(filter)).findFirst().orElse(null);
    }
}

