/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CategorizationContainerDisplay;
import io.intino.sumus.box.displays.CategorizationDisplay;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.notifiers.CategorizationComparatorDisplayNotifier;
import io.intino.sumus.graph.Categorization;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class CategorizationComparatorDisplay
extends CategorizationContainerDisplay<CategorizationComparatorDisplayNotifier> {
    private List<BiConsumer<Drill, Boolean>> applyListeners = new ArrayList<BiConsumer<Drill, Boolean>>();
    private List<Consumer<Drill>> quitListeners = new ArrayList<Consumer<Drill>>();
    private Drill drill;
    private Boolean includeGlobalSerie = true;
    private Timer executeDrillTimer = null;
    private static final int MaxCategoriesSelection = 5;

    public CategorizationComparatorDisplay(SumusBox box) {
        super(box);
    }

    @Override
    protected void init() {
        super.init();
        this.children(CategorizationDisplay.class).forEach(cd -> cd.maxSelection(5));
        ((CategorizationComparatorDisplayNotifier)this.notifier).refreshIncludeGlobalSerie(this.includeGlobalSerie);
    }

    @Override
    protected void sendRefreshCategorizationList(List<Categorization> categorizationList) {
        ((CategorizationComparatorDisplayNotifier)this.notifier).refreshCategorizationList(ItemBuilder.buildList(categorizationList));
    }

    @Override
    protected void sendRefreshTemporalCategorizationList(List<TemporalCategorization> categorizationList) {
    }

    public void apply() {
        this.applyListeners.forEach(l -> l.accept(this.clonedDrill(), this.includeGlobalSerie));
    }

    public void onApply(BiConsumer<Drill, Boolean> consumer) {
        this.applyListeners.add(consumer);
    }

    public void quit() {
        this.quitListeners.forEach(l -> l.accept(this.clonedDrill()));
    }

    public void onQuit(Consumer<Drill> consumer) {
        this.quitListeners.add(consumer);
    }

    public void includeGlobalSerie(Boolean value) {
        this.includeGlobalSerie = value;
        ((CategorizationComparatorDisplayNotifier)this.notifier).refreshIncludeGlobalSerie(this.includeGlobalSerie);
        this.applyDelayed();
    }

    @Override
    protected void addListeners(CategorizationDisplay categorizationDisplay) {
        categorizationDisplay.onSelect(categories -> this.updateDrill(categorizationDisplay));
    }

    private void updateDrill(CategorizationDisplay categorizationDisplay) {
        this.drill = categorizationDisplay.asDrill();
        this.applyDelayed();
    }

    private void applyDelayed() {
        if (this.executeDrillTimer != null) {
            this.executeDrillTimer.cancel();
        }
        this.executeDrillTimer = new Timer();
        this.executeDrillTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (CategorizationComparatorDisplay.this.drill == null) {
                    CategorizationComparatorDisplay.this.quit();
                } else {
                    CategorizationComparatorDisplay.this.apply();
                }
                CategorizationComparatorDisplay.this.executeDrillTimer = null;
            }
        }, 1000L);
    }

    private Drill clonedDrill() {
        if (this.drill == null) {
            return null;
        }
        return new Drill(this.drill.categorization, this.drill.categories);
    }
}

