/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.OlapDisplay;
import io.intino.sumus.box.displays.notifiers.CatalogOlapViewDisplayNotifier;
import io.intino.sumus.box.schemas.CatalogItem;
import io.intino.sumus.box.schemas.OpenItemDialogParameters;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Olap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class CatalogOlapViewDisplay
extends Display<CatalogOlapViewDisplayNotifier>
implements CatalogViewDisplay {
    private CatalogView view;
    private CatalogViewDisplayProvider provider;
    private SumusBox box;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();

    public CatalogOlapViewDisplay(SumusBox box) {
        this.box = box;
    }

    @Override
    public void view(CatalogView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<OpenItemDialogParameters> location) {
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
    }

    @Override
    public CatalogView view() {
        return this.view;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public void refresh() {
        super.refresh();
        ((OlapDisplay)this.child(OlapDisplay.class)).refresh();
    }

    protected void init() {
        super.init();
        this.buildOlapDisplay();
    }

    private void buildOlapDisplay() {
        OlapDisplay display = new OlapDisplay(this.box);
        display.olap(this.olap(this.view.option()));
        display.onLoading(this::notifyLoading);
        display.context(this.provider.context());
        this.add(display);
        display.personifyOnce();
    }

    private Olap olap(String option) {
        return this.box.graph().olapList().stream().filter(o -> o.name$().equals(option) || o.label().equals(option)).findFirst().orElse(null);
    }

    private void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    @Override
    public void refresh(CatalogItem ... items) {
    }
}

