/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.PageDisplay;
import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.builders.CatalogItemBuilder;
import io.intino.sumus.box.displays.builders.CatalogViewBuilder;
import io.intino.sumus.box.displays.notifiers.CatalogMapViewDisplayNotifier;
import io.intino.sumus.box.schemas.Bounds;
import io.intino.sumus.box.schemas.CatalogItem;
import io.intino.sumus.box.schemas.CatalogOperationParameters;
import io.intino.sumus.box.schemas.DownloadItemParameters;
import io.intino.sumus.box.schemas.OpenItemDialogParameters;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.helpers.Asset;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class CatalogMapViewDisplay
extends PageDisplay<CatalogMapViewDisplayNotifier>
implements CatalogViewDisplay {
    private CatalogView view;
    private CatalogViewDisplayProvider provider;
    private SumusBox box;
    private List<Consumer<OpenItemDialogParameters>> openDialogListeners = new ArrayList<Consumer<OpenItemDialogParameters>>();
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();

    public CatalogMapViewDisplay(SumusBox box) {
        this.box = box;
    }

    @Override
    public void view(CatalogView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<OpenItemDialogParameters> location) {
        this.openDialogListeners.add(location);
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public CatalogView view() {
        return this.view;
    }

    public int countItems() {
        return this.provider.countRecords(null);
    }

    public void page(Integer value) {
        super.page(value.intValue());
    }

    public void location(Bounds value) {
    }

    protected void init() {
        super.init();
        this.sendView();
    }

    @Override
    public void refresh() {
        this.notifyLoading(true);
        super.refresh();
        this.notifyLoading(false);
    }

    protected void sendItems(int start, int limit) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refresh(CatalogItemBuilder.buildList(this.provider.records(start, limit, null), this.provider.stamps(), this.provider.scale(), Asset.baseAssetUrl(this.session())));
    }

    protected void sendClear() {
        ((CatalogMapViewDisplayNotifier)this.notifier).clear();
    }

    protected void sendPageSize(int pageSize) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshPageSize(pageSize);
    }

    protected void sendCount(int count) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshCount(count);
    }

    private void sendView() {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshView(CatalogViewBuilder.build(this.view));
    }

    public void openItemDialogOperation(OpenItemDialogParameters params) {
        this.openDialogListeners.forEach(l -> l.accept(params));
    }

    @Override
    public void refresh(CatalogItem ... items) {
        Stream.of(items).forEach(item -> ((CatalogMapViewDisplayNotifier)this.notifier).refreshItem((CatalogItem)item));
    }

    private void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    public ActivityFile downloadItemOperation(DownloadItemParameters value) {
        return null;
    }

    public void executeOperation(CatalogOperationParameters value) {
        this.provider.executeOperation(value);
    }

    public ActivityFile downloadOperation(CatalogOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value);
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }
}

