/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.PageDisplay;
import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.displays.builders.CatalogItemBuilder;
import io.intino.sumus.box.displays.builders.CatalogSortingBuilder;
import io.intino.sumus.box.displays.builders.CatalogViewBuilder;
import io.intino.sumus.box.displays.builders.PictureDataBuilder;
import io.intino.sumus.box.displays.notifiers.CatalogListViewDisplayNotifier;
import io.intino.sumus.box.schemas.CatalogItem;
import io.intino.sumus.box.schemas.CatalogOperationParameters;
import io.intino.sumus.box.schemas.ClusterGroup;
import io.intino.sumus.box.schemas.DownloadItemParameters;
import io.intino.sumus.box.schemas.OpenItemDialogParameters;
import io.intino.sumus.box.schemas.Sorting;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.graph.picture.catalog.mold.block.PictureStamp;
import io.intino.sumus.helpers.Asset;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spark.utils.IOUtils;

public class CatalogListViewDisplay
extends PageDisplay<CatalogListViewDisplayNotifier>
implements CatalogViewDisplay {
    private SumusBox box;
    private CatalogViewDisplayProvider.Sorting sorting;
    private CatalogView view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<OpenItemDialogParameters>> openItemDialogListeners = new ArrayList<Consumer<OpenItemDialogParameters>>();
    private List<Consumer<Cluster>> createClusterListeners = new ArrayList<Consumer<Cluster>>();
    private String condition = null;
    private Map<String, List<StampDisplay>> recordDisplaysMap = new HashMap<String, List<StampDisplay>>();
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<String> lastSelection = new ArrayList<String>();

    public CatalogListViewDisplay(SumusBox box) {
        this.box = box;
    }

    @Override
    public void view(CatalogView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    public void selectSorting(Sorting sorting) {
        this.sorting = this.sortingOf(sorting);
        this.sendSelectedSorting();
        this.sendClear();
        this.page(0);
    }

    public int countItems() {
        return this.provider.countRecords(this.condition);
    }

    public void page(Integer value) {
        super.page(value.intValue());
    }

    @Override
    public void onOpenItemDialog(Consumer<OpenItemDialogParameters> listener) {
        this.openItemDialogListeners.add(listener);
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
        this.createClusterListeners.add(listener);
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public CatalogView view() {
        return this.view;
    }

    public void filter(String value) {
        this.condition = value;
        this.refresh();
    }

    @Override
    public void refresh(CatalogItem ... items) {
        Stream.of(items).forEach(this::refresh);
    }

    public void selection(String[] records) {
        ArrayList<String> newRecords = new ArrayList<String>(Arrays.asList(records));
        newRecords.removeAll(this.lastSelection);
        newRecords.forEach(record -> {
            if (!this.recordDisplaysMap.containsKey(record)) {
                this.renderDisplays((String)record);
            }
            this.renderExpandedPictures((String)record);
        });
        this.lastSelection = new ArrayList<String>(Arrays.asList(records));
    }

    public void renderExpandedPictures() {
        this.lastSelection.forEach(this::renderExpandedPictures);
    }

    private void renderDisplays(String item) {
        List<StampDisplay> displays = this.displays(item);
        displays.forEach(display -> {
            this.add((Display)display);
            display.personify(item);
            display.refresh();
        });
        this.recordDisplaysMap.put(item, displays);
    }

    private void renderExpandedPictures(String item) {
        this.refreshPictures(item, this.expandedPictures(item));
    }

    private void refreshPictures(String item) {
        this.refreshPictures(item, this.allPictures(item));
    }

    private void refreshPictures(String item, List<PictureStamp> pictures) {
        Record record = this.provider.record(new String(Base64.getDecoder().decode(item)));
        pictures.forEach(stamp -> {
            try {
                String name = stamp.name$();
                Object data = stamp.internalValue(record);
                if (!(data instanceof List) || ((List)data).size() != 1) {
                    return;
                }
                List values = (List)data;
                byte[] pictureBytes = IOUtils.toByteArray((InputStream)((URL)values.get(0)).openStream());
                byte[] picture = Base64.getEncoder().encode(pictureBytes);
                ((CatalogListViewDisplayNotifier)this.notifier).refreshPicture(PictureDataBuilder.build(record, name, "data:image/png;base64," + new String(picture)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void createClusterGroup(ClusterGroup value) {
        Cluster cluster = this.createCluster(value.cluster());
        Cluster.Group group = cluster.create().group(value.name());
        value.entities().forEach(entityName -> group.entities().add((Entity)this.provider.record(new String(Base64.getDecoder().decode((String)entityName))).a$(Entity.class)));
        cluster.save$();
        this.createClusterListeners.forEach(l -> l.accept(cluster));
    }

    private Cluster createCluster(String clusterLabel) {
        String username = this.session() != null && this.session().user() != null ? this.session().user().username() : null;
        Cluster cluster = this.box.graph().clusterList().stream().filter((? super T c) -> (c.username() == null || c.username() != null && c.username().equals(username)) && c.label().equals(clusterLabel)).findFirst().orElse(null);
        if (cluster != null) {
            return cluster;
        }
        cluster = this.box.graph().create("clusters").cluster(this.view.catalog(), clusterLabel, username);
        cluster.catalog().create().clusterGrouping(cluster).histogram(Catalog.AbstractGrouping.Histogram.Absolute);
        return cluster;
    }

    protected void sendItems(int start, int limit) {
        ((CatalogListViewDisplayNotifier)this.notifier).refresh(CatalogItemBuilder.buildList(this.provider.records(start, limit, this.condition, this.sorting), this.provider.stamps(), this.provider.scale(), Asset.baseAssetUrl(this.session())));
    }

    protected void sendClear() {
        ((CatalogListViewDisplayNotifier)this.notifier).clear();
    }

    protected void sendPageSize(int pageSize) {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshPageSize(pageSize);
    }

    protected void sendCount(int count) {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshCount(count);
    }

    protected void init() {
        super.init();
        List<Catalog.Sorting> sortings = this.provider.sortings();
        this.sorting = sortings.size() > 0 ? this.sortingOf(sortings.get(0)) : null;
        this.sendView();
        this.sendSortingList(sortings);
        this.sendSelectedSorting();
    }

    @Override
    public void refresh() {
        this.notifyLoading(true);
        super.refresh();
        this.notifyLoading(false);
    }

    private void sendView() {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshView(CatalogViewBuilder.build(this.view));
    }

    private void sendSortingList(List<Catalog.Sorting> sortings) {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshSortingList(CatalogSortingBuilder.buildList(sortings));
    }

    private void sendSelectedSorting() {
        if (this.sorting == null) {
            return;
        }
        ((CatalogListViewDisplayNotifier)this.notifier).refreshSelectedSorting(CatalogSortingBuilder.build(this.sorting));
    }

    private List<StampDisplay> displays(String record) {
        return this.provider.stamps().stream().filter(Catalog.Mold.Block.Stamp::isDisplay).map(stamp -> this.provider.display(stamp.name$())).filter(Objects::nonNull).map(display -> display.record(record)).collect(Collectors.toList());
    }

    private List<PictureStamp> expandedPictures(String record) {
        return this.provider.expandedStamps().stream().filter(Catalog.Mold.Block.Stamp::isPicture).map(Catalog.Mold.Block.Stamp::asPicture).collect(Collectors.toList());
    }

    private List<PictureStamp> allPictures(String record) {
        return this.provider.stamps().stream().filter(Catalog.Mold.Block.Stamp::isPicture).map(Catalog.Mold.Block.Stamp::asPicture).collect(Collectors.toList());
    }

    private CatalogViewDisplayProvider.Sorting sortingOf(Sorting sorting) {
        return this.sortingOf(sorting.name(), sorting.mode());
    }

    private CatalogViewDisplayProvider.Sorting sortingOf(Catalog.Sorting sorting) {
        return this.sortingOf(sorting.name$(), "Ascendant");
    }

    private CatalogViewDisplayProvider.Sorting sortingOf(final String name, final String mode) {
        return new CatalogViewDisplayProvider.Sorting(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public CatalogViewDisplayProvider.Sorting.Mode mode() {
                return CatalogViewDisplayProvider.Sorting.Mode.valueOf(mode);
            }

            @Override
            public int comparator(Record record1, Record record2) {
                return CatalogListViewDisplay.this.provider.sorting(name).comparator(record1, record2);
            }
        };
    }

    private void refresh(CatalogItem item) {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshItem(item);
        if (this.recordDisplaysMap.containsKey(item.name())) {
            this.recordDisplaysMap.get(item.name()).forEach(Display::refresh);
        }
    }

    public void itemRefreshed(String record) {
        this.refreshPictures(record);
    }

    private void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    public void openItemDialogOperation(OpenItemDialogParameters params) {
        this.openItemDialogListeners.forEach(l -> l.accept(params));
    }

    public ActivityFile downloadItemOperation(DownloadItemParameters value) {
        return null;
    }

    public void executeOperation(CatalogOperationParameters value) {
        this.provider.executeOperation(value);
    }

    public ActivityFile downloadOperation(CatalogOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value);
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }
}

