/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.Category;
import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.viewmodels.CatalogView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.box.displays.CatalogViewListDisplay;
import io.intino.sumus.box.displays.DialogContainerDisplay;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.displays.StampDisplayProvider;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.CatalogItemBuilder;
import io.intino.sumus.box.schemas.CatalogItem;
import io.intino.sumus.box.schemas.CatalogOperationParameters;
import io.intino.sumus.box.schemas.GroupingGroup;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.box.schemas.OpenItemDialogParameters;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.container.ContainerCatalog;
import io.intino.sumus.graph.entitycontainer.EntityContainerCatalog;
import io.intino.sumus.graph.eventcontainer.EventContainerCatalog;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.graph.reportcontainer.ReportContainerCatalog;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.queries.Scope;
import io.intino.tara.magritte.Concept;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CatalogDisplay<C extends ContainerCatalog, DN extends DisplayNotifier>
extends SumusDisplay<DN> {
    protected Map<String, GroupingSelection> groupingSelectionMap = new HashMap<String, GroupingSelection>();
    protected Scope scope = null;
    protected List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    protected StampDisplayProvider stampDisplayProvider = null;
    protected C catalog;
    private CatalogViewDisplay currentView = null;
    private String currentRecord = null;
    private Boolean dirty = null;

    public CatalogDisplay(SumusBox box) {
        super(box);
    }

    public boolean isFor(Catalog catalog) {
        return this.catalog.name$().equals(catalog.name$());
    }

    public void catalog(C catalog) {
        this.catalog = catalog;
    }

    public void stampDisplayProvider(StampDisplayProvider provider) {
        this.stampDisplayProvider = provider;
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void selectGrouping(GroupingSelection selection) {
        Catalog.AbstractGrouping abstractGrouping = this.groupingOf(selection.name());
        if (abstractGrouping.histogram() == Catalog.AbstractGrouping.Histogram.Absolute && selection.groups().size() <= 0) {
            this.groupingSelectionMap.remove(selection.name());
        } else {
            this.groupingSelectionMap.put(selection.name(), selection);
        }
        this.dirty = true;
        this.refreshGrouping();
    }

    public void deleteGroupingGroup(GroupingGroup groupingGroup) {
        Catalog.AbstractGrouping abstractGrouping = this.groupingOf(groupingGroup.grouping());
        if (!abstractGrouping.i$(Catalog.ClusterGrouping.class)) {
            return;
        }
        Catalog.ClusterGrouping grouping = (Catalog.ClusterGrouping)abstractGrouping.a$(Catalog.ClusterGrouping.class);
        Cluster.Group group = grouping.cluster().groupList().stream().filter(g -> g.name$().equals(groupingGroup.name())).findFirst().orElse(null);
        if (group == null) {
            return;
        }
        group.delete$();
        grouping.cluster().save$();
        this.sendCatalog();
        if (this.groupingSelectionMap.containsKey(groupingGroup.grouping())) {
            GroupingSelection groupingSelection = this.groupingSelectionMap.get(groupingGroup.grouping());
            groupingSelection.groups().remove(group.label());
            this.selectGrouping(groupingSelection);
        }
    }

    public Optional<CatalogViewDisplay> currentView() {
        return Optional.ofNullable(this.currentView);
    }

    public void refresh() {
        this.refreshView();
    }

    public void refreshView() {
        this.currentView().ifPresent(CatalogViewDisplay::refresh);
    }

    public void refresh(Record ... records) {
        this.currentView().ifPresent(v -> v.refresh(this.itemsOf(records)));
    }

    public void refresh(Categorization categorization) {
        this.sendCatalog();
        this.currentView().ifPresent(CatalogViewDisplay::refresh);
    }

    protected void resetGrouping() {
        this.groupingSelectionMap.clear();
        this.scope = null;
        this.queryEngine().filter(this.scope);
    }

    protected void refreshGrouping() {
        this.refreshScope();
        this.queryEngine().filter(this.scope);
        this.refreshView();
    }

    protected void init() {
        super.init();
        this.buildViewList();
        this.sendCatalog();
        this.createDialogContainer();
    }

    protected CatalogView catalogViewOf(final Catalog.View view) {
        return new CatalogView(){

            @Override
            public String name() {
                return view.core$().name();
            }

            @Override
            public String label() {
                return CatalogDisplay.this.catalogViewLabelOf(view);
            }

            @Override
            public String type() {
                return ((Object)((Object)view)).getClass().getSimpleName();
            }

            @Override
            public String option() {
                if (!view.i$(Catalog.OlapView.class)) {
                    return null;
                }
                return ((Catalog.OlapView)view.a$(Catalog.OlapView.class)).olap().name$();
            }

            @Override
            public Catalog.Toolbar toolbar() {
                return ((ContainerCatalog)((Object)CatalogDisplay.this.catalog)).toolbar();
            }

            @Override
            public int width() {
                if (view.i$(Catalog.MagazineView.class)) {
                    return ((Catalog.MagazineView)view.a$(Catalog.MagazineView.class)).width();
                }
                if (view.i$(Catalog.ListView.class)) {
                    return ((Catalog.ListView)view.a$(Catalog.ListView.class)).width();
                }
                if (view.i$(Catalog.GridView.class)) {
                    return ((Catalog.GridView)view.a$(Catalog.GridView.class)).width();
                }
                return 100;
            }

            @Override
            public Catalog.Mold mold() {
                if (view.i$(Catalog.MagazineView.class)) {
                    return ((Catalog.MagazineView)view.a$(Catalog.MagazineView.class)).mold();
                }
                if (view.i$(Catalog.ListView.class)) {
                    return ((Catalog.ListView)view.a$(Catalog.ListView.class)).mold();
                }
                if (view.i$(Catalog.GridView.class)) {
                    return ((Catalog.GridView)view.a$(Catalog.GridView.class)).mold();
                }
                if (view.i$(Catalog.MapView.class)) {
                    return ((Catalog.MapView)view.a$(Catalog.MapView.class)).mold();
                }
                return null;
            }

            @Override
            public Catalog.View rawView() {
                return view;
            }

            @Override
            public boolean canCreateClusters() {
                return CatalogDisplay.this.canCreateClusters();
            }

            @Override
            public List<String> clusters() {
                return ((ContainerCatalog)((Object)CatalogDisplay.this.catalog)).clusterGroupingList().stream().map(Catalog.AbstractGrouping::label).collect(Collectors.toList());
            }

            @Override
            public Catalog catalog() {
                return (Catalog)CatalogDisplay.this.catalog.a$(Catalog.class);
            }
        };
    }

    protected abstract void sendCatalog();

    protected abstract void showDialog();

    protected abstract <R extends Record> RecordList<R> records(String var1);

    protected abstract Record record(String var1);

    protected abstract boolean canCreateClusters();

    protected abstract TimeScale scale();

    protected boolean dirty() {
        return this.dirty == null || this.dirty != false;
    }

    protected List<CatalogView> viewList() {
        return ((ContainerCatalog)((Object)this.catalog)).viewList().stream().map(this::catalogViewOf).collect(Collectors.toList());
    }

    private void executeOperation(Catalog.Toolbar.AbstractOperation operation, String option) {
        if (operation.i$(Catalog.Toolbar.OpenDialogOperation.class)) {
            DialogContainerDisplay display = (DialogContainerDisplay)this.child(DialogContainerDisplay.class);
            display.dialogLocation(((Catalog.Toolbar.OpenDialogOperation)operation.a$(Catalog.Toolbar.OpenDialogOperation.class)).path());
            display.refresh();
            this.showDialog();
        } else {
            ((Catalog.Toolbar.Operation)operation.a$(Catalog.Toolbar.Operation.class)).execute((Catalog)this.catalog.a$(Catalog.class), option);
        }
    }

    private Resource downloadOperation(Catalog.Toolbar.AbstractOperation operation, CatalogOperationParameters params) {
        if (operation.i$(Catalog.Toolbar.ExportOperation.class)) {
            return ((Catalog.Toolbar.ExportOperation)operation.a$(Catalog.Toolbar.ExportOperation.class)).execute((Catalog)this.catalog.a$(Catalog.class), params.from(), params.to());
        }
        return ((Catalog.Toolbar.DownloadOperation)operation.a$(Catalog.Toolbar.DownloadOperation.class)).execute((Catalog)this.catalog.a$(Catalog.class), params.option());
    }

    private void buildViewList() {
        CatalogViewListDisplay display = new CatalogViewListDisplay(this.box);
        display.recordProvider(new CatalogViewDisplayProvider(){
            private String condition = null;
            private CatalogViewDisplayProvider.Sorting sorting = null;
            private RecordList<Record> recordList = null;

            @Override
            public Concept context() {
                if (CatalogDisplay.this.catalog.i$(EntityContainerCatalog.class)) {
                    return ((EntityContainerCatalog)CatalogDisplay.this.catalog.a$(EntityContainerCatalog.class)).entity();
                }
                if (CatalogDisplay.this.catalog.i$(EventContainerCatalog.class)) {
                    return ((EventContainerCatalog)CatalogDisplay.this.catalog.a$(EventContainerCatalog.class)).event();
                }
                if (CatalogDisplay.this.catalog.i$(ReportContainerCatalog.class)) {
                    return ((ReportContainerCatalog)CatalogDisplay.this.catalog.a$(ReportContainerCatalog.class)).report();
                }
                return null;
            }

            @Override
            public int countRecords(String condition) {
                this.updateCondition(condition);
                this.loadRecordList();
                return this.recordList.count();
            }

            @Override
            public List<Record> records(int start, int limit, String condition) {
                return this.records(start, limit, condition, null);
            }

            @Override
            public List<Record> records(int start, int limit, String condition, CatalogViewDisplayProvider.Sorting sorting) {
                this.updateCondition(condition);
                this.loadRecordList();
                return this.recordList.items(start, limit, sorting);
            }

            @Override
            public Record record(String id) {
                Record record = null;
                if (this.recordList != null) {
                    record = this.recordList.items().stream().filter(r -> r.core$().id().equals(id)).findFirst().orElse(null);
                }
                return record != null ? record : CatalogDisplay.this.record(id);
            }

            @Override
            public List<Catalog.Sorting> sortings() {
                return ((ContainerCatalog)((Object)CatalogDisplay.this.catalog)).sortingList();
            }

            @Override
            public TimeScale scale() {
                return CatalogDisplay.this.scale();
            }

            @Override
            public List<Catalog.Mold.Block.Stamp> stamps() {
                return CatalogDisplay.this.stamps();
            }

            @Override
            public List<Catalog.Mold.Block.Stamp> expandedStamps() {
                return CatalogDisplay.this.expandedStamps();
            }

            @Override
            public StampDisplay display(String stamp) {
                return CatalogDisplay.this.display(stamp);
            }

            @Override
            public Catalog.Sorting sorting(String key) {
                return ((ContainerCatalog)((Object)CatalogDisplay.this.catalog)).sortingList().stream().filter(s -> s.name$().equals(key) || s.label().equals(key)).findFirst().orElse(null);
            }

            @Override
            public void executeOperation(CatalogOperationParameters params) {
                Catalog.Toolbar.AbstractOperation operation = CatalogDisplay.this.operationOf(params);
                CatalogDisplay.this.executeOperation(operation, params.option());
            }

            @Override
            public Resource downloadOperation(CatalogOperationParameters params) {
                Catalog.Toolbar.AbstractOperation operation = CatalogDisplay.this.operationOf(params);
                return CatalogDisplay.this.downloadOperation(operation, params);
            }

            private void updateCondition(String condition) {
                if (this.condition != null && !this.condition.equals(condition)) {
                    CatalogDisplay.this.dirty = true;
                }
                this.condition = condition;
            }

            private void loadRecordList() {
                if (!CatalogDisplay.this.dirty() && this.recordList != null) {
                    return;
                }
                this.recordList = CatalogDisplay.this.records(this.condition);
                CatalogDisplay.this.dirty = false;
            }
        });
        display.viewList(this.viewList());
        display.onSelectView(this::updateCurrentView);
        display.onOpenItemDialog(this::openItemDialog);
        display.onLoading(this::notifyLoading);
        display.onCreateCluster(this::refreshCatalog);
        this.add(display);
        display.personifyOnce();
    }

    private void updateCurrentView(CatalogViewDisplay display) {
        this.currentView = display;
        this.refreshView();
    }

    private void refreshCatalog(Cluster cluster) {
        this.sendCatalog();
    }

    private void openItemDialog(OpenItemDialogParameters params) {
        this.currentRecord = new String(Base64.getDecoder().decode(params.item()));
        DialogContainerDisplay display = (DialogContainerDisplay)this.child(DialogContainerDisplay.class);
        Catalog.Mold.Block.Stamp stamp = this.stamp(params.stamp());
        display.dialogLocation(stamp.asOpenDialogOperation().path(params.item()));
        display.refresh();
        this.showDialog();
    }

    private void refreshScope() {
        if (this.groupingSelectionMap.size() <= 0) {
            this.scope = null;
            return;
        }
        if (this.scope == null) {
            this.scope = new Scope();
        }
        this.scope.clear();
        this.scope.categories(this.groupingSelectionMap.entrySet().stream().filter(this::isGrouping).collect(Collectors.toMap(Map.Entry::getKey, e -> this.categories((GroupingSelection)e.getValue()))));
        this.scope.records(this.groupingSelectionMap.entrySet().stream().filter(this::isCluster).collect(Collectors.toMap(Map.Entry::getKey, e -> this.records((GroupingSelection)e.getValue()))));
    }

    protected boolean isGrouping(Map.Entry<String, GroupingSelection> entry) {
        return this.groupingOf(entry.getKey()).i$(Catalog.Grouping.class);
    }

    protected boolean isCluster(Map.Entry<String, GroupingSelection> entry) {
        return this.groupingOf(entry.getKey()).i$(Catalog.ClusterGrouping.class);
    }

    protected StampDisplay display(String stamp) {
        return this.stampDisplayProvider != null ? this.stampDisplayProvider.display(stamp) : null;
    }

    private List<Category> categories(GroupingSelection selection) {
        return selection.groups().stream().map(group -> this.category(selection.name(), (String)group)).collect(Collectors.toList());
    }

    private Category category(String groupingName, String groupName) {
        return (Category)((Catalog.Grouping)this.groupingOf(groupingName).a$(Catalog.Grouping.class)).categorization().categoryMap().get(groupName);
    }

    private List<Record> records(GroupingSelection selection) {
        return selection.groups().stream().map(group -> this.records(selection.name(), (String)group)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Record> records(String groupingName, String groupName) {
        Catalog.AbstractGrouping grouping = this.groupingOf(groupingName);
        return this.recordsOf(grouping, groupName);
    }

    private List<Record> recordsOf(Catalog.AbstractGrouping grouping, String groupLabel) {
        Catalog.ClusterGrouping clusterGrouping = (Catalog.ClusterGrouping)grouping.a$(Catalog.ClusterGrouping.class);
        Cluster.Group group = clusterGrouping.cluster().groupList().stream().filter(g -> g.label().equals(groupLabel)).findFirst().orElse(null);
        return group != null ? group.entities().stream().map(e -> (Record)e.a$(Record.class)).collect(Collectors.toList()) : Collections.emptyList();
    }

    private Catalog.AbstractGrouping groupingOf(String groupingName) {
        return ((ContainerCatalog)((Object)this.catalog)).abstractGroupingList().stream().filter(g -> g.name$().equals(groupingName)).findFirst().orElse(null);
    }

    private String catalogViewLabelOf(Catalog.View view) {
        if (view.i$(Catalog.MagazineView.class)) {
            return ((Catalog.MagazineView)view.a$(Catalog.MagazineView.class)).label();
        }
        if (view.i$(Catalog.ListView.class)) {
            return ((Catalog.ListView)view.a$(Catalog.ListView.class)).label();
        }
        if (view.i$(Catalog.GridView.class)) {
            return ((Catalog.GridView)view.a$(Catalog.GridView.class)).label();
        }
        if (view.i$(Catalog.MapView.class)) {
            return ((Catalog.MapView)view.a$(Catalog.MapView.class)).label();
        }
        if (view.i$(Catalog.OlapView.class)) {
            String label = ((Catalog.OlapView)view.a$(Catalog.OlapView.class)).label();
            return !label.isEmpty() ? label : ((Catalog.OlapView)view.a$(Catalog.OlapView.class)).olap().label();
        }
        return "";
    }

    private List<Catalog.Mold.Block.Stamp> stamps() {
        return ((ContainerCatalog)((Object)this.catalog)).moldList().stream().map(Catalog.Mold::blockList).flatMap(Collection::stream).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Catalog.Mold.Block.Stamp> expandedStamps() {
        return ((ContainerCatalog)((Object)this.catalog)).moldList().stream().map(Catalog.Mold::blockList).flatMap(Collection::stream).filter(Catalog.Mold.Block::isExpanded).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Catalog.Mold.Block.Stamp> stamps(Catalog.Mold.Block block) {
        ArrayList<Catalog.Mold.Block.Stamp> stamps = new ArrayList<Catalog.Mold.Block.Stamp>();
        stamps.addAll(block.stampList());
        block.blockList().forEach(child -> stamps.addAll(this.stamps((Catalog.Mold.Block)((Object)child))));
        return stamps;
    }

    private Catalog.Mold.Block.Stamp stamp(String name) {
        return this.stamps().stream().filter(s -> s.name$().equals(name)).findFirst().orElse(null);
    }

    private void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    private void createDialogContainer() {
        DialogContainerDisplay display = new DialogContainerDisplay(this.box);
        display.onDialogAssertion(modification -> this.currentView().ifPresent(view -> {
            if (modification.toLowerCase().equals("itemmodified")) {
                view.refresh(this.currentItem());
            } else {
                view.refresh();
            }
        }));
        this.add(display);
        display.personifyOnce();
    }

    private CatalogItem currentItem() {
        return this.itemOf(this.record(this.currentRecord));
    }

    private CatalogItem itemOf(Record record) {
        return CatalogItemBuilder.build(record, this.stamps(), this.scale(), this.baseAssetUrl());
    }

    private CatalogItem[] itemsOf(Record ... records) {
        return (CatalogItem[])Stream.of(records).map(this::itemOf).toArray(CatalogItem[]::new);
    }

    private Catalog.Toolbar.AbstractOperation operationOf(CatalogOperationParameters params) {
        return ((ContainerCatalog)((Object)this.catalog)).toolbar().abstractOperationList().stream().filter(op -> op.name$().equals(params.operation())).findFirst().orElse(null);
    }
}

