/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.EntityCatalogDisplay;
import io.intino.sumus.box.displays.EventCatalogDisplay;
import io.intino.sumus.box.displays.ReportCatalogDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.container.ContainerCatalog;
import io.intino.sumus.graph.entitycontainer.EntityContainerCatalog;
import io.intino.sumus.graph.eventcontainer.EventContainerCatalog;
import io.intino.sumus.graph.reportcontainer.ReportContainerCatalog;
import io.intino.tara.magritte.Layer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class CatalogContainerDisplay<DN extends DisplayNotifier>
extends SumusDisplay<DN> {
    private List<Catalog> catalogList = new ArrayList<Catalog>();
    private Map<Class<? extends Layer>, Function<Catalog, CatalogDisplay>> builders = new HashMap<Class<? extends Layer>, Function<Catalog, CatalogDisplay>>();
    private Map<String, CatalogDisplay> displayMap = new HashMap<String, CatalogDisplay>();

    public CatalogContainerDisplay(SumusBox box) {
        super(box);
        this.registerBuilders();
    }

    protected void init() {
        super.init();
        this.buildCatalogDisplays();
    }

    public List<Catalog> catalogs() {
        return this.catalogList;
    }

    public void catalogs(List<Catalog> catalogList) {
        this.catalogList = catalogList;
    }

    public void selectCatalog(String label) {
        long count = this.children(CatalogDisplay.class).stream().filter(c -> ((ContainerCatalog)((Object)((Object)c.catalog))).label().equals(label)).count();
        if (count > 0L) {
            return;
        }
        this.refreshLoading(true);
        CatalogDisplay display = this.displayMap.get(label);
        this.add(display);
        display.onLoading(value -> {
            if (((Boolean)value).booleanValue()) {
                this.refreshLoading(false);
            } else {
                this.refreshLoaded();
            }
        });
        display.personifyOnce();
        this.refreshLoaded();
    }

    protected abstract void refreshLoading(boolean var1);

    protected abstract void refreshLoaded();

    private void buildCatalogDisplays() {
        this.catalogList.forEach(catalog -> this.register(this.buildCatalogDisplay(((Object)((Object)catalog.asContainer())).getClass()).forCatalog((Catalog)((Object)catalog))));
    }

    private void register(CatalogDisplay display) {
        this.displayMap.put(((ContainerCatalog)((Object)display.catalog)).label(), display);
    }

    protected CatalogBuilder buildCatalogDisplay(Class<? extends Layer> layer) {
        return catalog -> this.builders.get(layer).apply(catalog);
    }

    private void registerBuilders() {
        this.builders.put(EntityContainerCatalog.class, this::buildEntityCatalogDisplay);
        this.builders.put(EventContainerCatalog.class, this::buildEventCatalogDisplay);
        this.builders.put(ReportContainerCatalog.class, this::buildReportCatalogDisplay);
    }

    private CatalogDisplay buildEntityCatalogDisplay(Catalog catalog) {
        EntityCatalogDisplay display = new EntityCatalogDisplay(this.box);
        display.catalog((ContainerCatalog)catalog.a$(EntityContainerCatalog.class));
        return display;
    }

    private CatalogDisplay buildEventCatalogDisplay(Catalog catalog) {
        EventCatalogDisplay display = new EventCatalogDisplay(this.box);
        display.catalog((ContainerCatalog)catalog.a$(EventContainerCatalog.class));
        return display;
    }

    private CatalogDisplay buildReportCatalogDisplay(Catalog catalog) {
        ReportCatalogDisplay display = new ReportCatalogDisplay(this.box);
        display.catalog((ContainerCatalog)catalog.a$(ReportContainerCatalog.class));
        return display;
    }

    static interface CatalogBuilder {
        public CatalogDisplay forCatalog(Catalog var1);
    }
}

