/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.services.push.User;
import io.intino.sumus.Settings;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogContainerDisplay;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.builders.PlatformInfoBuilder;
import io.intino.sumus.box.displays.notifiers.AnalyticsDisplayNotifier;
import io.intino.sumus.box.schemas.Item;
import io.intino.sumus.box.schemas.PlatformInfo;
import io.intino.sumus.box.schemas.UserInfo;
import io.intino.sumus.graph.Catalog;
import java.util.List;
import java.util.stream.Collectors;

public class AnalyticsDisplay
extends CatalogContainerDisplay<AnalyticsDisplayNotifier> {
    public AnalyticsDisplay(SumusBox box) {
        super(box);
        this.catalogs(this.platform().catalogList());
    }

    public void logout() {
        this.session().logout();
        ((AnalyticsDisplayNotifier)this.notifier).userLoggedOut();
    }

    @Override
    public void selectCatalog(String name) {
        super.selectCatalog(name);
    }

    @Override
    protected void refreshLoading(boolean withMessage) {
        ((AnalyticsDisplayNotifier)this.notifier).loading(withMessage);
    }

    @Override
    protected void refreshLoaded() {
        ((AnalyticsDisplayNotifier)this.notifier).loaded();
    }

    @Override
    protected void init() {
        super.init();
        ((AnalyticsDisplayNotifier)this.notifier).info(this.info());
        this.currentUser().ifPresent(user -> ((AnalyticsDisplayNotifier)this.notifier).user(this.userOf((User)user)));
        this.sendCatalogList();
        ((AnalyticsDisplayNotifier)this.notifier).loaded();
    }

    private List<Item> itemsOf(List<Catalog> catalogList) {
        return catalogList.stream().map(ItemBuilder::build).collect(Collectors.toList());
    }

    private PlatformInfo info() {
        Settings configuration = this.box.actionsConfiguration();
        return PlatformInfoBuilder.build(configuration);
    }

    private UserInfo userOf(User user) {
        return new UserInfo().fullName(user.fullName()).photo(user.photo().toString());
    }

    private void sendCatalogList() {
        ((AnalyticsDisplayNotifier)this.notifier).refreshCatalogList(this.itemsOf(this.catalogs()));
    }
}

