/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.konos.BoxConfiguration;
import io.intino.konos.server.activity.services.AuthService;
import io.intino.sumus.box.SumusBox;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class SumusConfiguration
extends BoxConfiguration {
    PlatformWebConfiguration platformWebConfiguration;

    public SumusConfiguration(String[] args) {
        super(args);
        this.fillWithArgs();
    }

    private void fillWithArgs() {
        if (this.store == null && this.args.get("graph_store") != null) {
            this.store = new File((String)this.args.remove("graph_store"));
        }
        if (this.args.containsKey("platformWeb_port")) {
            this.platformWebConfiguration(this.toInt((String)this.args.remove("platformWeb_port")), (String)this.args.remove("platformWeb_webDirectory"), (String)this.args.remove("platformWeb_analyticsPath"));
            this.platformWebConfiguration.authService = SumusBox.authService(this.platformWebConfiguration.authServiceUrl());
        }
    }

    public File store() {
        return this.store;
    }

    public SumusConfiguration platformWebConfiguration(int port, String webDirectory, String analyticsPath) {
        this.platformWebConfiguration = new PlatformWebConfiguration();
        this.platformWebConfiguration.port = port;
        this.platformWebConfiguration.webDirectory = webDirectory == null ? "www/" : webDirectory;
        this.platformWebConfiguration.analyticsPath = analyticsPath;
        return this;
    }

    public SumusConfiguration platformWebConfiguration(int port, String analyticsPath) {
        return this.platformWebConfiguration(port, "www/", analyticsPath);
    }

    public PlatformWebConfiguration platformWebConfiguration() {
        return this.platformWebConfiguration;
    }

    public static class PlatformWebConfiguration {
        public int port;
        public String webDirectory;
        public AuthService authService;
        public String analyticsPath = "";

        public URL authServiceUrl() {
            try {
                return new URL("".replace("{analyticsPath}", this.analyticsPath));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }
}

