/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.konos.Box;
import io.intino.konos.server.activity.displays.Soul;
import io.intino.konos.server.activity.services.AuthService;
import io.intino.sumus.Settings;
import io.intino.sumus.box.AbstractBox;
import io.intino.sumus.box.SumusConfiguration;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.helpers.TranslatorHelper;
import io.intino.tara.magritte.Graph;
import java.net.URL;
import java.util.Collection;

public class SumusBox
extends AbstractBox {
    private SumusGraph sumusGraph;
    private Settings settings;
    private TranslatorHelper translatorHelper;

    public SumusBox(String[] args) {
        super(args);
    }

    public SumusBox(SumusConfiguration configuration) {
        super(configuration);
        this.settings = new Settings(configuration.args());
    }

    @Override
    public Box put(Object o) {
        if (o instanceof Graph) {
            this.sumusGraph = (SumusGraph)((Graph)o).as(SumusGraph.class);
        }
        if (o instanceof TranslatorHelper) {
            this.translatorHelper = (TranslatorHelper)o;
        }
        return this;
    }

    @Override
    public Box open() {
        this.translatorHelper = new TranslatorHelper(this.sumusGraph);
        super.open();
        this.graph().init();
        return this;
    }

    public SumusGraph graph() {
        return this.sumusGraph;
    }

    public Settings actionsConfiguration() {
        return this.settings;
    }

    @Override
    public void close() {
        super.close();
    }

    public TranslatorHelper translatorHelper() {
        return this.translatorHelper;
    }

    public void refreshDisplaysOf(Catalog catalog, Categorization categorization) {
        this.activitySouls.values().stream().map(Soul::getAll).flatMap(Collection::stream).filter(d -> d instanceof CatalogDisplay && ((CatalogDisplay)((Object)d)).isFor(catalog)).forEach(d -> ((CatalogDisplay)((Object)d)).refresh(categorization));
    }

    public <R extends Record> void refreshDisplaysOf(Catalog catalog, R ... records) {
        this.activitySouls.values().stream().map(Soul::getAll).flatMap(Collection::stream).filter(d -> d instanceof CatalogDisplay && ((CatalogDisplay)((Object)d)).isFor(catalog)).forEach(d -> {
            CatalogDisplay display = (CatalogDisplay)((Object)d);
            if (records.length == 0) {
                display.refresh();
            } else {
                display.refresh((Record[])records);
            }
        });
    }

    static AuthService authService(URL authServiceUrl) {
        return null;
    }
}

