/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.viewmodels;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Assertion {
    public final String type;
    public final Instant instant;
    public final List<Attribute> attributes;

    public Assertion(String type, List<Attribute> attributes) {
        this.type = type;
        this.instant = Assertion.findInstant(attributes);
        this.attributes = Collections.unmodifiableList(attributes);
    }

    private static Instant findInstant(List<Attribute> attributes) {
        return attributes.stream().filter(a -> a.key().equals("instant")).findFirst().map(a -> Assertion.instantOf((Long)((Attribute)a).value)).orElse(Instant.now(Clock.systemUTC()));
    }

    private static Instant instantOf(long milliseconds) {
        return Instant.ofEpochMilli(milliseconds);
    }

    public static class Attribute {
        private final String key;
        private final Object value;

        public Attribute(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public List<?> value() {
            return new ArrayList<Object>(Collections.singletonList(this.value));
        }
    }
}

