/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.metricscalers;

import io.intino.sumus.analytics.MetricScaler;
import io.intino.sumus.analytics.Scaler;
import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.Metric;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinearScaler
implements MetricScaler {
    private static final Map<Metric.Unit, Metric> map = new HashMap<Metric.Unit, Metric>();

    @Override
    public Scaler scaler(double value, AbstractMetric.Unit unit) {
        if (map.isEmpty()) {
            unit.graph().metricList(m -> m.i$(Metric.class)).forEach(metric -> metric.unitList().forEach(u -> map.put((Metric.Unit)u.a$(Metric.Unit.class), (Metric)((Object)metric))));
        }
        return value == 0.0 ? this.scalerWithFactorOne((Metric.Unit)unit.a$(Metric.Unit.class)) : this.findScaler(value, map.get(unit.a$(Metric.Unit.class)), (Metric.Unit)unit.a$(Metric.Unit.class));
    }

    private Scaler findScaler(double value, Metric metric, Metric.Unit originalUnit) {
        List<Metric.Unit> units = metric.metricUnitList();
        double factor = 1.0;
        value = originalUnit.convert(value);
        for (Metric.Unit unit : units) {
            factor = unit.convert(1.0);
            double x = Math.abs(value / factor);
            if (!(x >= 1.0) || !(x < 1000.0)) continue;
            return this.createScaler(originalUnit, unit, factor);
        }
        return this.createScaler(originalUnit, units.get(units.size() - 1), factor);
    }

    private Scaler scalerWithFactorOne(Metric.Unit originalUnit) {
        return map.get((Object)originalUnit).metricUnitList().stream().filter(unit -> unit.convert(1.0) == 1.0).map(unit -> this.createScaler(originalUnit, (Metric.Unit)((Object)unit), 1.0)).findFirst().orElse(null);
    }

    private Scaler createScaler(final Metric.Unit originalUnit, final Metric.Unit unit, final double factor) {
        return new Scaler(){

            @Override
            public String unitLabel() {
                return unit.label();
            }

            @Override
            public double scale(double value) {
                return originalUnit.convert(value) / factor;
            }
        };
    }
}

