/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.categorization;

import io.intino.sumus.Category;
import io.intino.sumus.CategoryMap;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.TranslatorHelper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class TemporalCategorization
extends Categorization {
    protected String name;
    protected String format;
    protected TranslatorHelper helper;
    protected String language;
    protected TimeRange range;

    public TemporalCategorization(String name, String format, Categorization parent, TimeRange range) {
        super(null);
        this.name = name;
        this.parent = parent;
        this.format = format;
        this.update(range);
        this.createCategories();
    }

    public TemporalCategorization(TimeRange range) {
        this("TemporalCategorization", "", null, range);
    }

    public TemporalCategorization helper(TranslatorHelper helper) {
        this.helper = helper;
        this.setup();
        return this;
    }

    @Override
    public Categorization parent() {
        return this.parent;
    }

    private void update(TimeRange timeRange) {
        TimeScale scale = timeRange.scale();
        this.range = new TimeRange(scale.normalise(timeRange.from()), scale.normalise(timeRange.to()), scale);
        Optional.ofNullable(this.parent()).ifPresent(parent -> ((TemporalCategorization)((Object)parent)).update(timeRange));
    }

    public TemporalCategorization language(String language) {
        this.language = language;
        this.setup();
        return this;
    }

    public String name$() {
        return this.name;
    }

    public TimeRange range() {
        return this.range;
    }

    public String format() {
        return this.format;
    }

    public boolean isAvailableForScale(TimeScale scale) {
        return scale.ordinal() >= this.range().scale().ordinal();
    }

    public void range(TimeRange timeRange) {
        this.update(timeRange);
    }

    private void setup() {
        if (this.helper == null || this.language == null) {
            return;
        }
        this.label(this.helper.translate(this.name).into(this.language));
    }

    private void createCategories() {
        this.categoryMap = new CategoryMap();
        this.range.allInstants().forEach(instant -> {
            String label = this.labelOf((Instant)instant);
            if (!this.categoryMap.containsKey(label)) {
                this.categoryMap.put(label, new TemporalCategory(new TimeStamp((Instant)instant, this.range.scale()), label, this.range.scale().sortingWeight((Instant)instant, this.format)));
            }
            ((Category)this.categoryMap.get(label)).recordIds().add(instant.toString());
        });
    }

    @Override
    public List<Category> categoryList() {
        ArrayList<Category> categories = new ArrayList<Category>(this.categoryMap.values());
        categories.sort(Comparator.comparingInt(c -> ((TemporalCategory)c).weight()));
        return categories;
    }

    private String labelOf(Instant instant) {
        return this.range.scale().toString(instant);
    }

    public static class TemporalCategory
    extends Category {
        private final int weight;
        private final TimeStamp timeStamp;
        private String name;

        TemporalCategory(TimeStamp timeStamp, String name, int weight) {
            super(name);
            this.timeStamp = timeStamp;
            this.name = name;
            this.weight = weight;
        }

        @Override
        public String name() {
            return this.name;
        }

        public int weight() {
            return this.weight;
        }

        public TimeStamp timeStamp() {
            return this.timeStamp;
        }
    }
}

