/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.categorization;

import io.intino.sumus.Category;
import io.intino.sumus.CategoryMap;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Layer;
import java.util.List;

public class CategoryProcessor {
    private final SumusGraph sumus;

    private CategoryProcessor(SumusGraph sumus) {
        this.sumus = sumus;
    }

    public static void categorize(SumusGraph sumus) {
        new CategoryProcessor(sumus).doCategorize();
    }

    public static void categorize(Categorization categorization) {
        new CategoryProcessor(categorization.graph()).doCategorize(categorization);
    }

    public static void categorize(Categorization categorization, List<? extends Layer> layers) {
        new CategoryProcessor(categorization.graph()).doCategorize(categorization, layers);
    }

    private void doCategorize() {
        this.doCategorize(this.sumus.categorizationList());
    }

    private void doCategorize(List<Categorization> categorizations) {
        for (Categorization categorization : categorizations) {
            if (categorization.record().is("TemporalRecord")) continue;
            CategoryProcessor.categorize(categorization);
        }
    }

    private void doCategorize(Categorization categorization) {
        this.doCategorize(categorization, categorization.graph().core$().find(categorization.record().layerClass()));
    }

    private void doCategorize(Categorization categorization, List<? extends Layer> recordList) {
        CategoryMap categoryMap = categorization.categoryMap();
        categoryMap.clear();
        for (Layer layer : recordList) {
            String category = categorization.attribute(layer);
            if (!categoryMap.containsKey(category)) {
                categoryMap.put(category, new Category(category));
            }
            ((Category)categoryMap.get(category)).recordIds().add(layer.core$().id());
        }
    }
}

