/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics;

import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.DataRetriever;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.Palette;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.functions.Command;
import io.intino.sumus.helpers.ColorHelper;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class View {
    private static final String ColorId = "%s.%s.%s";
    private static final HashMap<String, String> ColorMap = new HashMap();

    public static List createOlapListenerList(Olap self) {
        return new ArrayList();
    }

    public static void addOlapListener(Olap self, Command command) {
        self.listeners().add(command);
    }

    public static void notifyOlapListeners(Olap self) {
        self.listeners().forEach(listener -> ((Command)listener).execute());
    }

    public static Instant calculateOlapRangeFrom(Olap.Range self) {
        Olap olap = (Olap)self.core$().ownerAs(Olap.class);
        if (self.calculatedFrom() != null) {
            return self.calculatedFrom();
        }
        self.calculatedFrom(View.fromOf(olap));
        return self.calculatedFrom();
    }

    public static Instant calculateOlapRangeTo(Olap.Range self) {
        Olap olap = (Olap)self.core$().ownerAs(Olap.class);
        if (self.calculatedTo() != null) {
            return self.calculatedTo();
        }
        self.calculatedTo(View.toOf(olap));
        return self.calculatedTo();
    }

    public static boolean resetOlapRange(Olap.Range self) {
        self.calculatedFrom(null);
        self.calculatedTo(null);
        return true;
    }

    private static Instant fromOf(Olap olap) {
        return PathBuilder.range(View.nameSpacesOf(olap)).from();
    }

    private static Instant toOf(Olap olap) {
        return PathBuilder.range(View.nameSpacesOf(olap)).to();
    }

    private static NameSpace[] nameSpacesOf(Olap olap) {
        return olap.nameSpaces().toArray(new NameSpace[0]);
    }

    public static String paletteColorOf(Palette self, Ticket ticket, DataRetriever dataRetriever, Palette.Color.Type type) {
        String id = String.format(ColorId, ticket.name$(), dataRetriever.name$(), type.toString());
        if (ColorMap.containsKey(id)) {
            return ColorMap.get(id);
        }
        List<Palette.Color> colors = self.colorList(c -> c.id().equals(id));
        boolean colorDefined = colors.size() > 0;
        ColorMap.put(id, colorDefined ? colors.get(0).colorCode() : ColorHelper.newColor());
        return ColorMap.get(id);
    }

    public static String ticketColor(Ticket self) {
        return self.graph().palette().colorOf(self, self.dataRetriever(), Palette.Color.Type.Main);
    }

    public static String paletteColorId(Palette.Color self) {
        return self.ticket().name$() + "." + self.dataRetriever().name$() + "." + self.type().toString();
    }

    public static String catalogGroupingLabel(Catalog.AbstractGrouping self) {
        if (self.i$(Catalog.Grouping.class)) {
            return ((Catalog.Grouping)self.a$(Catalog.Grouping.class)).categorization().label();
        }
        if (self.i$(Catalog.ClusterGrouping.class)) {
            return ((Catalog.ClusterGrouping)self.a$(Catalog.ClusterGrouping.class)).cluster().label();
        }
        return "";
    }

    public static Object catalogStampValue(Catalog.Mold.Block.Stamp self, Record record) {
        if (self.isRating()) {
            return self.asRating().rating(record);
        }
        if (self.isSumusIcon()) {
            return self.asSumusIcon().icon(record);
        }
        if (self.isBase64Icon()) {
            return self.asBase64Icon().icon(record);
        }
        if (self.isResourceIcon()) {
            return self.asResourceIcon().icon(record);
        }
        if (self.isHighlight()) {
            return self.asHighlight().value(record);
        }
        if (self.isTitle()) {
            return self.asTitle().title(record);
        }
        if (self.isDescription()) {
            return self.asDescription().description(record);
        }
        if (self.isLocation()) {
            return self.asLocation().wkt(record);
        }
        if (self.isPicture()) {
            return self.asPicture().picture(record);
        }
        if (self.isBreadcrumbs()) {
            return self.asBreadcrumbs().tree(record);
        }
        if (self.isHyperlinks()) {
            return self.asHyperlinks().links(record);
        }
        if (self.isSnippet()) {
            return self.asSnippet().code(record);
        }
        return "";
    }

    public static Instant exportOperationFrom(Catalog.Toolbar.ExportOperation self) {
        return Instant.now(Clock.systemUTC());
    }

    public static Instant exportOperationTo(Catalog.Toolbar.ExportOperation self) {
        return Instant.now(Clock.systemUTC()).plus(1L, ChronoUnit.DAYS);
    }
}

