/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.sumus.helpers.UtcDateTime;
import io.intino.tara.io.Stash;
import io.intino.tara.magritte.stores.FileSystemStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SumusStore
extends FileSystemStore {
    public SumusStore(File file) {
        super(file);
    }

    public File storeFolder() {
        return this.file;
    }

    public Stash stashFrom(String path) {
        Stash stash = super.stashFrom(path);
        return stash == null ? this.defaultStash() : stash;
    }

    private Stash defaultStash() {
        Stash defaultStash = new Stash();
        defaultStash.language = "Sumus";
        return defaultStash;
    }

    public Instant minInstantForNameSpace(String nameSpace) {
        List<File> years = this.years(nameSpace);
        return this.findInLowerThanDayScale(years).findFirst().orElseGet(() -> this.findInLowerThanYearScale(years).findFirst().orElse(Instant.now(Clock.systemUTC())));
    }

    public Instant maxInstantForNameSpace(String nameSpace) {
        List<File> years = this.years(nameSpace);
        return this.findInLowerThanDayScale(years).reduce((l, r) -> r).orElseGet(() -> this.findInLowerThanYearScale(years).reduce((l, r) -> r).orElse(Instant.now(Clock.systemUTC())));
    }

    private Stream<Instant> findInLowerThanDayScale(List<File> years) {
        return years.stream().map(File::toPath).flatMap(this::list).flatMap(this::list).map(Path::toFile).filter(this::isNotMacFile).map(this::toInstant).sorted();
    }

    private Stream<Instant> findInLowerThanYearScale(List<File> years) {
        return years.stream().map(File::toPath).flatMap(this::list).map(Path::toFile).filter(this::isNotMacFile).map(this::toInstantUntilDay).sorted();
    }

    private Instant toInstant(File file) {
        File dayFile = file.getParentFile();
        int day = Integer.valueOf(dayFile.getName());
        File yearFile = dayFile.getParentFile();
        int year = Integer.valueOf(yearFile.getName());
        String time = this.afterDash(file.getName());
        int hour = Integer.valueOf(time.substring(0, 2));
        int minutes = time.length() <= 2 ? 0 : Integer.valueOf(time.substring(2));
        return new UtcDateTime(year, 1, 1, hour, minutes).plusDays(day - 1).toInstant();
    }

    private Instant toInstantUntilDay(File file) {
        int day = Integer.valueOf(this.afterDash(file.getName()));
        File yearFile = file.getParentFile();
        int year = Integer.valueOf(yearFile.getName());
        return new UtcDateTime(year, 1, 1, 0, 0).plusDays(day - 1).toInstant();
    }

    private List<File> years(String nameSpace) {
        List directories = this.list(new File(this.file, nameSpace + "-digests").toPath()).map(Path::toFile).filter(File::isDirectory).filter(this::isNotMacFile).collect(Collectors.toList());
        directories.addAll(this.list(new File(this.file, nameSpace + "-events").toPath()).map(Path::toFile).filter(File::isDirectory).filter(this::isNotMacFile).collect(Collectors.toList()));
        directories = directories.stream().map(d -> this.list(d.toPath())).flatMap(p -> p.map(Path::toFile)).filter(File::isDirectory).filter(this::isNotMacFile).collect(Collectors.toList());
        return directories.stream().filter(f -> f.getName().matches("\\d+")).sorted(File::compareTo).collect(Collectors.toList());
    }

    private boolean isNotMacFile(File file) {
        return !file.toString().contains(".DS_Store");
    }

    private Stream<Path> list(Path path) {
        try {
            return Files.list(path);
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    private String afterDash(String fileName) {
        if (!fileName.contains("-")) {
            return fileName;
        }
        if (!(fileName = fileName.substring(fileName.indexOf("-") + 1, fileName.lastIndexOf("."))).contains("-")) {
            return fileName;
        }
        return fileName.substring(0, fileName.indexOf("-"));
    }

    public String absoluteFilename(String storeFilename) {
        return this.file.getAbsoluteFile() + File.separator + storeFilename;
    }
}

