/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.sumus.box.displays.CatalogViewDisplayProvider;
import io.intino.sumus.graph.Record;
import java.util.Collections;
import java.util.List;

public class RecordList<T extends Record> {
    private final List<T> records;
    private CatalogViewDisplayProvider.Sorting sorting = null;

    public RecordList(List<T> records) {
        this.records = records;
    }

    public int count() {
        return this.records.size();
    }

    public RecordList<T> sort(CatalogViewDisplayProvider.Sorting sorting) {
        if (sorting == null || this.sorting == sorting) {
            return this;
        }
        this.sorting = sorting;
        this.records.sort(sorting::comparator);
        if (sorting.mode() == CatalogViewDisplayProvider.Sorting.Mode.Descendant) {
            Collections.reverse(this.records);
        }
        return this;
    }

    public List<T> items() {
        return this.records;
    }

    public List<T> items(int start, int limit) {
        int end = start + limit;
        if (end > this.records.size()) {
            end = this.records.size();
        }
        return this.records.subList(start, end);
    }

    public List<T> items(int start, int limit, CatalogViewDisplayProvider.Sorting sorting) {
        this.sort(sorting);
        return this.items(start, limit);
    }
}

