/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus;

import io.intino.sumus.Category;
import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.viewmodels.CrossTable;
import io.intino.sumus.analytics.viewmodels.Histogram;
import io.intino.sumus.analytics.viewmodels.Serie;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.CrossTableHelper;
import io.intino.sumus.helpers.EntityHelper;
import io.intino.sumus.helpers.ExportDocumentHelper;
import io.intino.sumus.helpers.HistogramHelper;
import io.intino.sumus.helpers.TemporalRecordHelper;
import io.intino.sumus.helpers.TimeSeriesHelper;
import io.intino.sumus.queries.CrossTableQuery;
import io.intino.sumus.queries.EntityQuery;
import io.intino.sumus.queries.HistogramQuery;
import io.intino.sumus.queries.Scope;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.sumus.queries.TimeSeriesQuery;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public class QueryEngine {
    private final SumusBox box;
    private Scope scope = null;

    public QueryEngine(SumusBox box) {
        this.box = box;
    }

    public QueryEngine filter(Scope scope) {
        this.scope = scope;
        return this;
    }

    public List<Serie> timeSeries(TimeSeriesQuery query) {
        query.scope(this.scope);
        return new TimeSeriesHelper().execute(query);
    }

    public List<DocumentRow> document(TimeSeriesQuery query) {
        query.scope(this.scope);
        return new ExportDocumentHelper().execute(query);
    }

    public CrossTable crossTable(CrossTableQuery query) {
        query.scope(this.scope);
        return new CrossTableHelper().execute(query);
    }

    public Histogram histogram(HistogramQuery query) {
        query.scope(this.scope);
        return new HistogramHelper().execute(query);
    }

    public RecordList<Entity> entities(EntityQuery query) {
        query.scope(this.scope);
        return new EntityHelper(this.box).entities(query);
    }

    public Entity entity(String id) {
        return new EntityHelper(this.box).entity(id);
    }

    public TimeRange temporalRecordRange(NameSpace nameSpace) {
        return new TemporalRecordHelper(this.box).recordRange(nameSpace);
    }

    public RecordList<TemporalRecord> temporalRecords(TemporalRecordQuery query) {
        query.scope(this.scope);
        return new TemporalRecordHelper(this.box).records(query);
    }

    public TemporalRecord temporalRecord(String id) {
        return new TemporalRecordHelper(this.box).record(id);
    }

    public static class DocumentRow {
        public final Instant internalInstant;
        public final String instant;
        public final String indicator;
        public final Map<Categorization, Category> drill;
        public final Map<Categorization, List<Category>> filter;
        public final Double value;
        public final String unitLabel;

        public DocumentRow(Instant instant, String indicator, Map<Categorization, Category> drill, Map<Categorization, List<Category>> filter, Double value, String unitLabel, TimeScale scale) {
            this.internalInstant = instant;
            this.instant = scale.toString(instant);
            this.indicator = indicator;
            this.drill = drill;
            this.filter = filter;
            this.value = value;
            this.unitLabel = unitLabel;
        }
    }
}

