/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.temporalrecord;

import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.queries.temporalrecord.CategorizationSeeker;
import io.intino.sumus.queries.temporalrecord.Query;
import io.intino.sumus.queries.temporalrecord.QueryResult;
import io.intino.tara.magritte.Graph;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class QueryExecutor {
    private final Query query;
    private final QueryResult result;

    private QueryExecutor(Query query) {
        this.query = query;
        this.result = new QueryResult(query);
    }

    public static QueryResult execute(Query query) {
        QueryExecutor executor = new QueryExecutor(query);
        executor.execute();
        return executor.result;
    }

    private void execute() {
        Graph clone = this.query.nameSpace().graph().core$().clone();
        clone.loadStashes(new String[]{PathBuilder.temporalRecordPath(this.query.nameSpace(), this.query.temporalRecord(), this.query.timeStamp())});
        clone.rootList(this.query.temporalRecord().layerClass()).stream().map(e -> (TemporalRecord)e.core$().as(TemporalRecord.class)).filter(this::isInFilter).filter(this::hasCondition).forEach(this.result::register);
    }

    private boolean hasCondition(TemporalRecord temporalRecord) {
        String condition = this.query.condition();
        if (condition == null || condition.isEmpty()) {
            return true;
        }
        List<String> keys = Arrays.asList(condition.toLowerCase().split(" "));
        List words = temporalRecord.core$().variables().values().stream().flatMap(Collection::stream).filter(s -> s instanceof String).map(s -> (String)s).collect(Collectors.toList());
        return keys.stream().filter(key -> words.stream().filter(word -> word.toLowerCase().contains((CharSequence)key)).count() > 0L).count() == (long)keys.size();
    }

    private boolean isInFilter(TemporalRecord temporalRecord) {
        return this.query.filter() == null || this.query.filter().contains(this.idsOf(CategorizationSeeker.entitiesOf(temporalRecord)));
    }

    private List<String> idsOf(List<Entity> entities) {
        return entities.stream().map(e -> e.core$().id()).collect(Collectors.toList());
    }
}

