/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.temporalrecord;

import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CategorizationSeeker {
    public static List<Categorization> categorizationsOf(NameSpace nameSpace, Concept temporalRecord, TimeScale scale, Instant instant) {
        return CategorizationSeeker.categorizationsOf(nameSpace, temporalRecord, new TimeStamp(instant, scale));
    }

    public static List<Categorization> categorizationsOf(NameSpace nameSpace, Concept temporalRecord, TimeStamp timeStamp) {
        List<TemporalRecord> records = CategorizationSeeker.temporalRecords(temporalRecord, nameSpace, timeStamp);
        if (records.isEmpty()) {
            return Collections.emptyList();
        }
        List<Entity> entities = CategorizationSeeker.entitiesOf(records.get(0));
        return nameSpace.graph().categorizationList(c -> CategorizationSeeker.canBeUsedOn(entities, c)).collect(Collectors.toList());
    }

    public static List<Entity> entitiesOf(TemporalRecord record) {
        return record.core$().variables().values().stream().filter(CategorizationSeeker::isDimension).map(CategorizationSeeker::toEntity).collect(Collectors.toList());
    }

    private static List<TemporalRecord> temporalRecords(Concept temporalRecord, NameSpace nameSpace, TimeStamp timeStamp) {
        Graph graph = nameSpace.graph().core$().clone();
        graph.loadStashes(new String[]{PathBuilder.temporalRecordPath(nameSpace, temporalRecord, timeStamp)});
        return graph.rootList(TemporalRecord.class);
    }

    private static boolean isDimension(List<?> varValues) {
        return !varValues.isEmpty() && varValues.get(0) instanceof Layer && ((Layer)varValues.get(0)).core$().is(Entity.class);
    }

    private static Entity toEntity(List<?> varValues) {
        return (Entity)((Layer)varValues.get(0)).core$().as(Entity.class);
    }

    private static boolean canBeUsedOn(List<Entity> entities, Categorization categorization) {
        for (Entity entity : entities) {
            if (!entity.core$().is(categorization.entity())) continue;
            return true;
        }
        return false;
    }
}

