/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.FormulaLoader;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.queries.AbstractQuery;
import io.intino.sumus.queries.TimeSeriesQuery;
import io.intino.sumus.queries.digest.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistogramQuery
extends AbstractQuery {
    private final List<Ticket> tickets = new ArrayList<Ticket>();
    private final Map<Categorization, List<Category>> filters = new HashMap<Categorization, List<Category>>();
    private TimeSeriesQuery.SortBy sortBy = null;
    private Categorization categorization = null;
    private NameSpace nameSpace;
    private TimeRange timeRange;

    private HistogramQuery() {
    }

    public List<Ticket> tickets() {
        return this.tickets;
    }

    public Categorization categorization() {
        return this.categorization;
    }

    public Map<Categorization, List<Category>> filters() {
        return this.filters;
    }

    public TimeSeriesQuery.SortBy sortBy() {
        return this.sortBy;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public TimeRange timeRange() {
        return this.timeRange;
    }

    public Query toRawQuery(FormulaLoader loader, List<Category> categories) {
        Query result = new Query();
        if (this.scope != null) {
            this.scope.values().forEach(entities -> result.filter(entities.toArray(new Entity[0])));
        }
        loader.formulas(this.tickets, this.timeRange).forEach(formula -> result.add(this.nameSpace, (MeasureIndicator.Formula)((Object)formula)));
        result.add(this.timeRange);
        this.filters().values().forEach(filterCategories -> result.filter(filterCategories.toArray(new Category[filterCategories.size()])));
        categories.forEach(xva$0 -> result.drill((Category)xva$0));
        return result;
    }

    public static class Builder {
        private final HistogramQuery query = new HistogramQuery();

        public HistogramQuery build(NameSpace nameSpace, Categorization categorization, TimeRange timeRange, TimeSeriesQuery.SortBy sortBy) {
            this.nameSpace(nameSpace);
            this.categorization(categorization);
            this.timeRange(timeRange);
            this.sortBy(sortBy);
            return this.query;
        }

        public Builder addTickets(List<Ticket> tickets) {
            this.query.tickets.addAll(tickets);
            return this;
        }

        public Builder addTicket(Ticket ticket) {
            this.query.tickets.add(ticket);
            return this;
        }

        private Builder nameSpace(NameSpace nameSpace) {
            this.query.nameSpace = nameSpace;
            return this;
        }

        private Builder timeRange(TimeRange timeRange) {
            this.query.timeRange = timeRange;
            return this;
        }

        private Builder categorization(Categorization categorization) {
            this.query.categorization = categorization;
            return this;
        }

        private Builder sortBy(TimeSeriesQuery.SortBy sortBy) {
            this.query.sortBy = sortBy;
            return this;
        }

        public Builder filter(Categorization categorization, List<Category> category) {
            this.query.filters.put(categorization, category);
            return this;
        }

        public Builder filter(List<FilterCondition> filterConditions) {
            filterConditions.forEach(filter -> this.query.filters.put(filter.categorization, filter.categories));
            return this;
        }
    }
}

