/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Filter {
    private final List<Set<String>> entityIds = new ArrayList<Set<String>>();
    private final Map<TimeStamp, TemporalCategorization.TemporalCategory> temporalCategories = new HashMap<TimeStamp, TemporalCategorization.TemporalCategory>();

    public void add(Category ... categories) {
        ArrayList<Category> entityCategories = new ArrayList<Category>();
        for (Category category : categories) {
            if (category instanceof TemporalCategorization.TemporalCategory) {
                this.add((TemporalCategorization.TemporalCategory)category);
                continue;
            }
            entityCategories.add(category);
        }
        this.add(entityCategories);
    }

    private void add(List<Category> entityCategories) {
        HashSet<String> entities = new HashSet<String>();
        for (Category category : entityCategories) {
            entities.addAll(category.entityIds());
        }
        this.entityIds.add(entities);
    }

    private void add(TemporalCategorization.TemporalCategory category) {
        this.temporalCategories.put(category.timeStamp(), category);
    }

    public boolean contains(List<String> ids) {
        for (Set<String> entities : this.entityIds) {
            if (this.containsAnyOf(ids, entities)) continue;
            return false;
        }
        return true;
    }

    private boolean containsAnyOf(List<String> ids, Set<String> entities) {
        for (String id : ids) {
            if (!entities.contains(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isTemporal() {
        return !this.temporalCategories.isEmpty();
    }

    public boolean contains(TimeStamp timeStamp) {
        if (this.temporalCategories.isEmpty()) {
            return true;
        }
        for (TimeStamp stamp : this.temporalCategories.keySet()) {
            if (!stamp.contains(timeStamp)) continue;
            return true;
        }
        return false;
    }
}

