/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Drill {
    private final String id;
    private final List<Category> categories = new ArrayList<Category>();
    private TemporalCategorization.TemporalCategory category = null;

    public Drill(String id, Category[] categories) {
        this.id = id;
        for (Category category : categories) {
            if (category instanceof TemporalCategorization.TemporalCategory) {
                this.category = (TemporalCategorization.TemporalCategory)category;
                continue;
            }
            this.categories.add(category);
        }
    }

    public String toString() {
        return this.id;
    }

    public List<Category> categories() {
        return new ArrayList<Category>(this.categories);
    }

    public boolean contains(List<String> ids) {
        for (Category category : this.categories) {
            if (category.contains(ids)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String ... ids) {
        return this.contains(Arrays.asList(ids));
    }

    public List<String> ids() {
        ArrayList<String> result = new ArrayList<String>();
        this.categories.forEach(c -> result.addAll(c.entityIds()));
        return result;
    }

    public TemporalCategorization.TemporalCategory temporalCategory() {
        return this.category;
    }

    public TimeStamp timeStamp() {
        return this.category.timeStamp();
    }

    public boolean isTemporal() {
        return this.category != null;
    }
}

